%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% File:          mc13.m
%
% Dimension:     2 (imbedded in 3)
% Domain:        A bridge truss, touching solid ground on the two ends
%                (via Dirichlet faces) and with a special Neumann face
%                in the middle of the top edge for applying forces.
% Boundary:      Combination of Dirichlet and Neumann.
%
% rcsid="$Id: mc13.m,v 1.2 2008/03/21 23:51:30 fetk Exp $"
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% MC = < Manifold Code >
%%% Copyright (C) 1994--2008 Michael Holst 
%%%
%%% This library is free software; you can redistribute it and/or 
%%% modify it under the terms of the GNU Lesser General Public 
%%% License as published by the Free Software Foundation; either  
%%% version 2.1 of the License, or (at your option) any later version. 
%%%
%%% This library is distributed in the hope that it will be useful, 
%%% but WITHOUT ANY WARRANTY; without even the implied warranty of             
%%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
%%% Lesser General Public License for more details. 
%%%
%%% You should have received a copy of the GNU Lesser General Public 
%%% License along with this library; if not, write to the Free Software  
%%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA   
%%%
%%% rcsid="$Id: mc13.m,v 1.2 2008/03/21 23:51:30 fetk Exp $"
%%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

mcsf_begin=1;

      dim=2;    % intrinsic manifold dimension
    dimii=3;    % imbedding manifold dimension
 vertices=248;    % number of vertices
simplices=260;    % number of simplices

vert=[
%-------- ---- ----------------- ----------------- -----------------
% Vert-ID Chrt X0-Coordinate     X1-Coordinate     X2-Coordinate
%-------- ---- ----------------- ----------------- -----------------
0         0     4.9144100000e+01  0.0000000000e+00  0.0000000000e+00
1         0     4.3145400000e+01  1.0390000000e+01  0.0000000000e+00
2         0     5.9987000000e+00  1.0390000000e+01  0.0000000000e+00
3         0     0.0000000000e+00  0.0000000000e+00  0.0000000000e+00
4         0     1.7321000000e+00  1.0000000000e+00  0.0000000000e+00
5         0     1.1420000000e+01  1.0000000000e+00  0.0000000000e+00
6         0     6.5760500000e+00  9.3900000000e+00  0.0000000000e+00
7         0     7.7300500000e+00  9.3900000000e+00  0.0000000000e+00
8         0     1.2574700000e+01  1.0000000000e+00  0.0000000000e+00
9         0     1.7417950000e+01  9.3900000000e+00  0.0000000000e+00
10        0     1.8573350000e+01  9.3900000000e+00  0.0000000000e+00
11        0     1.3729400000e+01  1.0000000000e+00  0.0000000000e+00
12        0     2.3417300000e+01  1.0000000000e+00  0.0000000000e+00
13        0     1.9728050000e+01  9.3900000000e+00  0.0000000000e+00
14        0     2.4572000000e+01  1.0000000000e+00  0.0000000000e+00
15        0     2.9415950000e+01  9.3900000000e+00  0.0000000000e+00
16        0     3.0570650000e+01  9.3900000000e+00  0.0000000000e+00
17        0     2.5726700000e+01  1.0000000000e+00  0.0000000000e+00
18        0     3.5414600000e+01  1.0000000000e+00  0.0000000000e+00
19        0     4.1413250000e+01  9.3900000000e+00  0.0000000000e+00
20        0     3.1723850000e+01  9.3900000000e+00  0.0000000000e+00
21        0     3.6569300000e+01  1.0000000000e+00  0.0000000000e+00
22        0     4.2567950000e+01  9.3900000000e+00  0.0000000000e+00
23        0     3.7724000000e+01  1.0000000000e+00  0.0000000000e+00
24        0     4.7411900000e+01  1.0000000000e+00  0.0000000000e+00
25        0     4.2401055642e+01  1.0390000000e+01  0.0000000000e+00
26        0     4.1614717306e+01  1.0390000000e+01  0.0000000000e+00
27        0     3.0854147463e+01  1.0390000000e+01  0.0000000000e+00
28        0     2.9125742849e+01  1.0390000000e+01  0.0000000000e+00
29        0     1.8870905519e+01  1.0390000000e+01  0.0000000000e+00
30        0     1.7154363291e+01  1.0390000000e+01  0.0000000000e+00
31        0     6.7201505857e+00  1.0390000000e+01  0.0000000000e+00
32        0     1.9887727261e+00  0.0000000000e+00  0.0000000000e+00
33        0     9.7431686051e-01  1.6875576676e+00  0.0000000000e+00
34        0     1.2299466455e+01  0.0000000000e+00  0.0000000000e+00
35        0     1.4028928830e+01  1.1102230246e-16  0.0000000000e+00
36        0     1.2932814043e+01  1.6203637678e+00  0.0000000000e+00
37        0     2.4291265967e+01  1.1102230246e-16  0.0000000000e+00
38        0     2.6017396224e+01  1.1102230246e-16  0.0000000000e+00
39        0     2.4930161625e+01  1.6203565346e+00  0.0000000000e+00
40        0     3.6271747735e+01  0.0000000000e+00  0.0000000000e+00
41        0     3.7987711088e+01  1.1102230246e-16  0.0000000000e+00
42        0     3.6927461625e+01  1.6203565346e+00  0.0000000000e+00
43        0     6.9340063711e+00  8.7699989773e+00  0.0000000000e+00
44        0     7.4996252612e+00  1.0390000000e+01  0.0000000000e+00
45        0     4.8169744530e+01  1.6876245408e+00  0.0000000000e+00
46        0     4.7199882637e+01  0.0000000000e+00  0.0000000000e+00
47        0     4.2209788375e+01  8.7696434654e+00  0.0000000000e+00
48        0     3.0212488375e+01  8.7696434654e+00  0.0000000000e+00
49        0     1.8214983136e+01  8.7692879795e+00  0.0000000000e+00
50        0     4.7541701464e+01  2.7754214732e+00  0.0000000000e+00
51        0     4.6913658398e+01  3.8632184056e+00  0.0000000000e+00
52        0     4.6285615331e+01  4.9510153380e+00  0.0000000000e+00
53        0     4.5657572265e+01  6.0388122704e+00  0.0000000000e+00
54        0     4.5029529199e+01  7.1266092028e+00  0.0000000000e+00
55        0     4.4401486133e+01  8.2144061352e+00  0.0000000000e+00
56        0     4.3773443066e+01  9.3022030676e+00  0.0000000000e+00
57        0     4.3259942857e+01  8.1914285714e+00  0.0000000000e+00
58        0     4.3951935714e+01  6.9928571429e+00  0.0000000000e+00
59        0     4.4643928571e+01  5.7942857143e+00  0.0000000000e+00
60        0     4.5335921429e+01  4.5957142857e+00  0.0000000000e+00
61        0     4.6027914286e+01  3.3971428571e+00  0.0000000000e+00
62        0     4.6719907143e+01  2.1985714286e+00  0.0000000000e+00
63        0     2.4240928571e+00  2.1985714286e+00  0.0000000000e+00
64        0     3.1160857143e+00  3.3971428571e+00  0.0000000000e+00
65        0     3.8080785714e+00  4.5957142857e+00  0.0000000000e+00
66        0     4.5000714286e+00  5.7942857143e+00  0.0000000000e+00
67        0     5.1920642857e+00  6.9928571429e+00  0.0000000000e+00
68        0     5.8840571429e+00  8.1914285714e+00  0.0000000000e+00
69        0     5.3706521076e+00  9.3021947085e+00  0.0000000000e+00
70        0     4.7426042151e+00  8.2143894169e+00  0.0000000000e+00
71        0     4.1145563227e+00  7.1265841254e+00  0.0000000000e+00
72        0     3.4865084303e+00  6.0387788338e+00  0.0000000000e+00
73        0     2.8584605378e+00  4.9509735423e+00  0.0000000000e+00
74        0     2.2304126454e+00  3.8631682507e+00  0.0000000000e+00
75        0     1.6023647529e+00  2.7753629592e+00  0.0000000000e+00
76        0     4.8715843025e-01  8.4377883381e-01  0.0000000000e+00
77        0     9.9438636303e-01  0.0000000000e+00  0.0000000000e+00
78        0     7.5748626038e+00  7.6599991234e+00  0.0000000000e+00
79        0     8.2157188365e+00  6.5499992695e+00  0.0000000000e+00
80        0     8.8565750692e+00  5.4399994156e+00  0.0000000000e+00
81        0     9.4974313019e+00  4.3299995617e+00  0.0000000000e+00
82        0     1.0138287535e+01  3.2199997078e+00  0.0000000000e+00
83        0     1.0779143767e+01  2.1099998539e+00  0.0000000000e+00
84        0     1.1969118750e+01  2.0487500000e+00  0.0000000000e+00
85        0     1.1363537500e+01  3.0975000000e+00  0.0000000000e+00
86        0     1.0757956250e+01  4.1462500000e+00  0.0000000000e+00
87        0     1.0152375000e+01  5.1950000000e+00  0.0000000000e+00
88        0     9.5467937500e+00  6.2437500000e+00  0.0000000000e+00
89        0     8.9412125000e+00  7.2925000000e+00  0.0000000000e+00
90        0     8.3356312500e+00  8.3412500000e+00  0.0000000000e+00
91        0     1.8012634405e+01  1.0390000000e+01  0.0000000000e+00
92        0     1.3164197643e+01  5.5511151231e-17  0.0000000000e+00
93        0     1.9178843750e+01  8.3412500000e+00  0.0000000000e+00
94        0     1.9784337500e+01  7.2925000000e+00  0.0000000000e+00
95        0     2.0389831250e+01  6.2437500000e+00  0.0000000000e+00
96        0     2.0995325000e+01  5.1950000000e+00  0.0000000000e+00
97        0     2.1600818750e+01  4.1462500000e+00  0.0000000000e+00
98        0     2.2206312500e+01  3.0975000000e+00  0.0000000000e+00
99        0     2.2811806250e+01  2.0487500000e+00  0.0000000000e+00
100       0     2.3966506250e+01  2.0487500000e+00  0.0000000000e+00
101       0     2.3361012500e+01  3.0975000000e+00  0.0000000000e+00
102       0     2.2755518750e+01  4.1462500000e+00  0.0000000000e+00
103       0     2.2150025000e+01  5.1950000000e+00  0.0000000000e+00
104       0     2.1544531250e+01  6.2437500000e+00  0.0000000000e+00
105       0     2.0939037500e+01  7.2925000000e+00  0.0000000000e+00
106       0     2.0333543750e+01  8.3412500000e+00  0.0000000000e+00
107       0     2.9989945156e+01  1.0390000000e+01  0.0000000000e+00
108       0     2.5154331095e+01  1.1102230246e-16  0.0000000000e+00
109       0     3.1176143750e+01  8.3412500000e+00  0.0000000000e+00
110       0     3.1781637500e+01  7.2925000000e+00  0.0000000000e+00
111       0     3.2387131250e+01  6.2437500000e+00  0.0000000000e+00
112       0     3.2992625000e+01  5.1950000000e+00  0.0000000000e+00
113       0     3.3598118750e+01  4.1462500000e+00  0.0000000000e+00
114       0     3.4203612500e+01  3.0975000000e+00  0.0000000000e+00
115       0     3.4809106250e+01  2.0487500000e+00  0.0000000000e+00
116       0     3.5963618750e+01  2.0487500000e+00  0.0000000000e+00
117       0     3.5357937500e+01  3.0975000000e+00  0.0000000000e+00
118       0     3.4752256250e+01  4.1462500000e+00  0.0000000000e+00
119       0     3.4146575000e+01  5.1950000000e+00  0.0000000000e+00
120       0     3.3540893750e+01  6.2437500000e+00  0.0000000000e+00
121       0     3.2935212500e+01  7.2925000000e+00  0.0000000000e+00
122       0     3.2329531250e+01  8.3412500000e+00  0.0000000000e+00
123       0     3.7129729411e+01  5.5511151231e-17  0.0000000000e+00
124       0     1.0036014286e+01  1.0000000000e+00  0.0000000000e+00
125       0     8.6520285714e+00  1.0000000000e+00  0.0000000000e+00
126       0     7.2680428571e+00  1.0000000000e+00  0.0000000000e+00
127       0     5.8840571429e+00  1.0000000000e+00  0.0000000000e+00
128       0     4.5000714286e+00  1.0000000000e+00  0.0000000000e+00
129       0     3.1160857143e+00  1.0000000000e+00  0.0000000000e+00
130       0     3.2776094422e+00  0.0000000000e+00  0.0000000000e+00
131       0     4.5664461583e+00  0.0000000000e+00  0.0000000000e+00
132       0     5.8552828744e+00  0.0000000000e+00  0.0000000000e+00
133       0     7.1441195905e+00  0.0000000000e+00  0.0000000000e+00
134       0     8.4329563066e+00  0.0000000000e+00  0.0000000000e+00
135       0     9.7217930228e+00  0.0000000000e+00  0.0000000000e+00
136       0     1.1010629739e+01  0.0000000000e+00  0.0000000000e+00
137       0     9.1140357143e+00  9.3900000000e+00  0.0000000000e+00
138       0     1.0498021429e+01  9.3900000000e+00  0.0000000000e+00
139       0     1.1882007143e+01  9.3900000000e+00  0.0000000000e+00
140       0     1.3265992857e+01  9.3900000000e+00  0.0000000000e+00
141       0     1.4649978571e+01  9.3900000000e+00  0.0000000000e+00
142       0     1.6033964286e+01  9.3900000000e+00  0.0000000000e+00
143       0     1.5775115001e+01  1.0390000000e+01  0.0000000000e+00
144       0     1.4395866711e+01  1.0390000000e+01  0.0000000000e+00
145       0     1.3016618421e+01  1.0390000000e+01  0.0000000000e+00
146       0     1.1637370131e+01  1.0390000000e+01  0.0000000000e+00
147       0     1.0258121841e+01  1.0390000000e+01  0.0000000000e+00
148       0     8.8788735512e+00  1.0390000000e+01  0.0000000000e+00
149       0     2.2033314286e+01  1.0000000000e+00  0.0000000000e+00
150       0     2.0649328571e+01  1.0000000000e+00  0.0000000000e+00
151       0     1.9265342857e+01  1.0000000000e+00  0.0000000000e+00
152       0     1.7881357143e+01  1.0000000000e+00  0.0000000000e+00
153       0     1.6497371429e+01  1.0000000000e+00  0.0000000000e+00
154       0     1.5113385714e+01  1.0000000000e+00  0.0000000000e+00
155       0     1.5494976993e+01  1.1102230246e-16  0.0000000000e+00
156       0     1.6961025155e+01  1.1102230246e-16  0.0000000000e+00
157       0     1.8427073317e+01  1.1102230246e-16  0.0000000000e+00
158       0     1.9893121480e+01  1.1102230246e-16  0.0000000000e+00
159       0     2.1359169642e+01  1.1102230246e-16  0.0000000000e+00
160       0     2.2825217805e+01  1.1102230246e-16  0.0000000000e+00
161       0     2.1112035714e+01  9.3900000000e+00  0.0000000000e+00
162       0     2.2496021429e+01  9.3900000000e+00  0.0000000000e+00
163       0     2.3880007143e+01  9.3900000000e+00  0.0000000000e+00
164       0     2.5263992857e+01  9.3900000000e+00  0.0000000000e+00
165       0     2.6647978571e+01  9.3900000000e+00  0.0000000000e+00
166       0     2.8031964286e+01  9.3900000000e+00  0.0000000000e+00
167       0     2.7660766088e+01  1.0390000000e+01  0.0000000000e+00
168       0     2.6195789326e+01  1.0390000000e+01  0.0000000000e+00
169       0     2.4730812565e+01  1.0390000000e+01  0.0000000000e+00
170       0     2.3265835803e+01  1.0390000000e+01  0.0000000000e+00
171       0     2.1800859042e+01  1.0390000000e+01  0.0000000000e+00
172       0     2.0335882280e+01  1.0390000000e+01  0.0000000000e+00
173       0     3.4030614286e+01  1.0000000000e+00  0.0000000000e+00
174       0     3.2646628571e+01  1.0000000000e+00  0.0000000000e+00
175       0     3.1262642857e+01  1.0000000000e+00  0.0000000000e+00
176       0     2.9878657143e+01  1.0000000000e+00  0.0000000000e+00
177       0     2.8494671429e+01  1.0000000000e+00  0.0000000000e+00
178       0     2.7110685714e+01  1.0000000000e+00  0.0000000000e+00
179       0     2.7482303582e+01  9.5161973539e-17  0.0000000000e+00
180       0     2.8947210941e+01  7.9301644616e-17  0.0000000000e+00
181       0     3.0412118300e+01  6.3441315693e-17  0.0000000000e+00
182       0     3.1877025659e+01  4.7580986770e-17  0.0000000000e+00
183       0     3.3341933017e+01  3.1720657846e-17  0.0000000000e+00
184       0     3.4806840376e+01  1.5860328923e-17  0.0000000000e+00
185       0     3.3108050000e+01  9.3900000000e+00  0.0000000000e+00
186       0     3.4492250000e+01  9.3900000000e+00  0.0000000000e+00
187       0     3.5876450000e+01  9.3900000000e+00  0.0000000000e+00
188       0     3.7260650000e+01  9.3900000000e+00  0.0000000000e+00
189       0     3.8644850000e+01  9.3900000000e+00  0.0000000000e+00
190       0     4.0029050000e+01  9.3900000000e+00  0.0000000000e+00
191       0     4.0269646075e+01  1.0390000000e+01  0.0000000000e+00
192       0     3.8924574845e+01  1.0390000000e+01  0.0000000000e+00
193       0     3.7579503615e+01  1.0390000000e+01  0.0000000000e+00
194       0     3.6234432384e+01  1.0390000000e+01  0.0000000000e+00
195       0     3.4889361154e+01  1.0390000000e+01  0.0000000000e+00
196       0     3.3544289924e+01  1.0390000000e+01  0.0000000000e+00
197       0     3.2199218694e+01  1.0390000000e+01  0.0000000000e+00
198       0     4.6027914286e+01  1.0000000000e+00  0.0000000000e+00
199       0     4.4643928571e+01  1.0000000000e+00  0.0000000000e+00
200       0     4.3259942857e+01  1.0000000000e+00  0.0000000000e+00
201       0     4.1875957143e+01  1.0000000000e+00  0.0000000000e+00
202       0     4.0491971429e+01  1.0000000000e+00  0.0000000000e+00
203       0     3.9107985714e+01  1.0000000000e+00  0.0000000000e+00
204       0     3.9303735595e+01  9.5161973539e-17  0.0000000000e+00
205       0     4.0619760102e+01  7.9301644616e-17  0.0000000000e+00
206       0     4.1935784609e+01  6.3441315693e-17  0.0000000000e+00
207       0     4.3251809116e+01  4.7580986770e-17  0.0000000000e+00
208       0     4.4567833623e+01  3.1720657846e-17  0.0000000000e+00
209       0     4.5883858130e+01  1.5860328923e-17  0.0000000000e+00
210       0     4.8171991319e+01  0.0000000000e+00  0.0000000000e+00
211       0     4.8656922265e+01  8.4381227040e-01  0.0000000000e+00
212       0     4.0772423089e+01  8.2800509335e+00  0.0000000000e+00
213       0     4.0131596179e+01  7.1701018670e+00  0.0000000000e+00
214       0     3.9490769268e+01  6.0601528006e+00  0.0000000000e+00
215       0     3.8849942357e+01  4.9502037341e+00  0.0000000000e+00
216       0     3.8209115447e+01  3.8402546676e+00  0.0000000000e+00
217       0     3.7568288536e+01  2.7303056011e+00  0.0000000000e+00
218       0     3.8364826911e+01  2.1099490665e+00  0.0000000000e+00
219       0     3.9005653821e+01  3.2198981330e+00  0.0000000000e+00
220       0     3.9646480732e+01  4.3298471994e+00  0.0000000000e+00
221       0     4.0287307643e+01  5.4397962659e+00  0.0000000000e+00
222       0     4.0928134553e+01  6.5497453324e+00  0.0000000000e+00
223       0     4.1568961464e+01  7.6596943989e+00  0.0000000000e+00
224       0     2.8775123089e+01  8.2800509335e+00  0.0000000000e+00
225       0     2.8134296179e+01  7.1701018670e+00  0.0000000000e+00
226       0     2.7493469268e+01  6.0601528006e+00  0.0000000000e+00
227       0     2.6852642357e+01  4.9502037341e+00  0.0000000000e+00
228       0     2.6211815447e+01  3.8402546676e+00  0.0000000000e+00
229       0     2.5570988536e+01  2.7303056011e+00  0.0000000000e+00
230       0     2.6367526911e+01  2.1099490665e+00  0.0000000000e+00
231       0     2.7008353821e+01  3.2198981330e+00  0.0000000000e+00
232       0     2.7649180732e+01  4.3298471994e+00  0.0000000000e+00
233       0     2.8290007643e+01  5.4397962659e+00  0.0000000000e+00
234       0     2.8930834553e+01  6.5497453324e+00  0.0000000000e+00
235       0     2.9571661464e+01  7.6596943989e+00  0.0000000000e+00
236       0     1.6777216292e+01  8.2800519668e+00  0.0000000000e+00
237       0     1.6136482584e+01  7.1701039336e+00  0.0000000000e+00
238       0     1.5495748875e+01  6.0601559005e+00  0.0000000000e+00
239       0     1.4855015167e+01  4.9502078673e+00  0.0000000000e+00
240       0     1.4214281459e+01  3.8402598341e+00  0.0000000000e+00
241       0     1.3573547751e+01  2.7303118009e+00  0.0000000000e+00
242       0     1.4370197591e+01  2.1098982828e+00  0.0000000000e+00
243       0     1.5010995182e+01  3.2197965656e+00  0.0000000000e+00
244       0     1.5651792772e+01  4.3296948483e+00  0.0000000000e+00
245       0     1.6292590363e+01  5.4395931311e+00  0.0000000000e+00
246       0     1.6933387954e+01  6.5494914139e+00  0.0000000000e+00
247       0     1.7574185545e+01  7.6593896967e+00  0.0000000000e+00
];

simp=[
%-------- ---- ---- ------------------- ---------------------------------------
% Simp-ID Grp  Mat  Face-Types          Vertex-Numbers
%-------- ---- ---- ------------------- ---------------------------------------
0         0    0    2    0    0         22 1 25
1         0    0    2    0    0         22 56 1
2         0    0    0    2    0         57 56 22
3         0    0    2    0    0         57 55 56
4         0    0    0    2    0         58 55 57
5         0    0    2    0    0         58 54 55
6         0    0    0    2    0         59 54 58
7         0    0    2    0    0         59 53 54
8         0    0    0    2    0         60 53 59
9         0    0    2    0    0         60 52 53
10        0    0    0    2    0         61 52 60
11        0    0    2    0    0         61 51 52
12        0    0    2    0    0         61 50 51
13        0    0    0    2    0         62 50 61
14        0    0    2    0    0         62 45 50
15        0    0    0    0    2         62 24 45
16        0    0    0    2    0         2 6 31
17        0    0    0    2    0         69 6 2
18        0    0    2    0    0         69 68 6
19        0    0    0    2    0         70 68 69
20        0    0    2    0    0         70 67 68
21        0    0    0    2    0         71 67 70
22        0    0    2    0    0         71 66 67
23        0    0    0    2    0         72 66 71
24        0    0    2    0    0         72 65 66
25        0    0    0    2    0         73 65 72
26        0    0    2    0    0         73 64 65
27        0    0    0    2    0         74 64 73
28        0    0    0    2    0         75 64 74
29        0    0    2    0    0         75 63 64
30        0    0    0    2    0         33 63 75
31        0    0    0    0    2         4 63 33
32        0    0    2    1    0         77 76 3
33        0    0    0    0    0         77 4 76
34        0    0    0    2    0         32 4 77
35        0    0    2    0    0         4 33 76
36        0    0    0    0    0         8 5 34
37        0    0    0    2    0         84 5 8
38        0    0    2    0    0         84 83 5
39        0    0    0    2    0         85 83 84
40        0    0    2    0    0         85 82 83
41        0    0    0    2    0         86 82 85
42        0    0    2    0    0         86 81 82
43        0    0    0    2    0         87 81 86
44        0    0    2    0    0         87 80 81
45        0    0    0    2    0         88 80 87
46        0    0    2    0    0         88 79 80
47        0    0    0    2    0         89 79 88
48        0    0    2    0    0         89 78 79
49        0    0    0    2    0         90 78 89
50        0    0    2    0    0         90 43 78
51        0    0    0    0    2         90 7 43
52        0    0    0    2    0         10 9 49
53        0    0    0    0    2         29 91 10
54        0    0    0    0    0         91 9 10
55        0    0    0    2    0         30 9 91
56        0    0    0    2    0         8 11 36
57        0    0    0    0    2         34 92 8
58        0    0    0    0    0         92 11 8
59        0    0    0    2    0         35 11 92
60        0    0    0    0    0         10 13 29
61        0    0    0    2    0         93 13 10
62        0    0    2    0    0         93 106 13
63        0    0    0    2    0         94 106 93
64        0    0    2    0    0         94 105 106
65        0    0    0    2    0         95 105 94
66        0    0    2    0    0         95 104 105
67        0    0    0    2    0         96 104 95
68        0    0    2    0    0         96 103 104
69        0    0    0    2    0         97 103 96
70        0    0    2    0    0         97 102 103
71        0    0    0    2    0         98 102 97
72        0    0    2    0    0         98 101 102
73        0    0    0    2    0         99 101 98
74        0    0    2    0    0         99 100 101
75        0    0    0    2    0         12 100 99
76        0    0    2    0    0         12 14 100
77        0    0    0    0    0         12 37 14
78        0    0    0    2    0         16 15 48
79        0    0    0    0    2         27 107 16
80        0    0    0    0    0         107 15 16
81        0    0    0    2    0         28 15 107
82        0    0    0    2    0         14 17 39
83        0    0    0    0    2         37 108 14
84        0    0    0    0    0         108 17 14
85        0    0    0    2    0         38 17 108
86        0    0    0    0    0         16 20 27
87        0    0    0    2    0         109 20 16
88        0    0    2    0    0         109 122 20
89        0    0    0    2    0         110 122 109
90        0    0    2    0    0         110 121 122
91        0    0    0    2    0         111 121 110
92        0    0    2    0    0         111 120 121
93        0    0    0    2    0         112 120 111
94        0    0    2    0    0         112 119 120
95        0    0    0    2    0         113 119 112
96        0    0    2    0    0         113 118 119
97        0    0    0    2    0         114 118 113
98        0    0    2    0    0         114 117 118
99        0    0    0    2    0         115 117 114
100       0    0    2    0    0         115 116 117
101       0    0    0    2    0         18 116 115
102       0    0    2    0    0         18 21 116
103       0    0    0    0    0         18 40 21
104       0    0    0    2    0         22 19 47
105       0    0    0    0    2         25 26 22
106       0    0    0    0    0         26 19 22
107       0    0    0    2    0         21 23 42
108       0    0    0    0    2         40 123 21
109       0    0    0    0    0         123 23 21
110       0    0    0    2    0         41 23 123
111       0    0    2    0    0         32 129 4
112       0    0    0    2    0         130 129 32
113       0    0    2    0    0         130 128 129
114       0    0    0    2    0         131 128 130
115       0    0    2    0    0         131 127 128
116       0    0    0    2    0         132 127 131
117       0    0    0    2    0         133 127 132
118       0    0    2    0    0         133 126 127
119       0    0    0    2    0         134 126 133
120       0    0    2    0    0         134 125 126
121       0    0    0    2    0         135 125 134
122       0    0    2    0    0         135 124 125
123       0    0    0    2    0         136 124 135
124       0    0    2    0    0         136 5 124
125       0    0    0    0    2         136 34 5
126       0    0    2    0    0         30 142 9
127       0    0    0    2    0         143 142 30
128       0    0    2    0    0         143 141 142
129       0    0    0    2    0         144 141 143
130       0    0    2    0    0         144 140 141
131       0    0    0    2    0         145 140 144
132       0    0    2    0    0         145 139 140
133       0    0    0    2    0         146 139 145
134       0    0    2    0    0         146 138 139
135       0    0    0    2    0         147 138 146
136       0    0    2    0    0         147 137 138
137       0    0    0    2    0         148 137 147
138       0    0    2    0    0         148 7 137
139       0    0    0    0    2         148 44 7
140       0    0    0    2    0         31 6 44
141       0    0    0    0    0         6 7 44
142       0    0    0    2    0         43 7 6
143       0    0    2    0    0         35 154 11
144       0    0    0    2    0         155 154 35
145       0    0    2    0    0         155 153 154
146       0    0    0    2    0         156 153 155
147       0    0    2    0    0         156 152 153
148       0    0    0    2    0         157 152 156
149       0    0    2    0    0         157 151 152
150       0    0    0    2    0         158 151 157
151       0    0    2    0    0         158 150 151
152       0    0    0    2    0         159 150 158
153       0    0    2    0    0         159 149 150
154       0    0    0    2    0         160 149 159
155       0    0    2    0    0         160 12 149
156       0    0    0    0    2         160 37 12
157       0    0    2    0    0         28 166 15
158       0    0    0    2    0         167 166 28
159       0    0    2    0    0         167 165 166
160       0    0    0    2    0         168 165 167
161       0    0    2    0    0         168 164 165
162       0    0    0    4    0         169 164 168
163       0    0    2    0    0         169 163 164
164       0    0    0    2    0         170 163 169
165       0    0    2    0    0         170 162 163
166       0    0    0    2    0         171 162 170
167       0    0    2    0    0         171 161 162
168       0    0    0    2    0         172 161 171
169       0    0    2    0    0         172 13 161
170       0    0    0    0    2         172 29 13
171       0    0    2    0    0         38 178 17
172       0    0    0    2    0         179 178 38
173       0    0    2    0    0         179 177 178
174       0    0    0    2    0         180 177 179
175       0    0    2    0    0         180 176 177
176       0    0    0    2    0         181 176 180
177       0    0    2    0    0         181 175 176
178       0    0    0    2    0         182 175 181
179       0    0    2    0    0         182 174 175
180       0    0    0    2    0         183 174 182
181       0    0    2    0    0         183 173 174
182       0    0    0    2    0         184 173 183
183       0    0    2    0    0         184 18 173
184       0    0    0    0    2         184 40 18
185       0    0    0    2    0         191 19 26
186       0    0    2    0    0         191 190 19
187       0    0    0    2    0         192 190 191
188       0    0    2    0    0         192 189 190
189       0    0    0    2    0         193 189 192
190       0    0    2    0    0         193 188 189
191       0    0    0    2    0         194 188 193
192       0    0    2    0    0         194 187 188
193       0    0    0    2    0         195 187 194
194       0    0    2    0    0         195 186 187
195       0    0    0    2    0         196 186 195
196       0    0    2    0    0         196 185 186
197       0    0    0    2    0         197 185 196
198       0    0    2    0    0         197 20 185
199       0    0    0    0    2         197 27 20
200       0    0    2    0    0         41 203 23
201       0    0    0    2    0         204 203 41
202       0    0    2    0    0         204 202 203
203       0    0    0    2    0         205 202 204
204       0    0    2    0    0         205 201 202
205       0    0    0    2    0         206 201 205
206       0    0    2    0    0         206 200 201
207       0    0    0    2    0         207 200 206
208       0    0    0    2    0         208 200 207
209       0    0    2    0    0         208 199 200
210       0    0    0    2    0         209 199 208
211       0    0    2    0    0         209 198 199
212       0    0    0    2    0         46 198 209
213       0    0    0    0    2         24 198 46
214       0    0    1    2    0         211 210 0
215       0    0    0    0    0         211 24 210
216       0    0    0    2    0         45 24 211
217       0    0    2    0    0         24 46 210
218       0    0    0    2    0         218 42 23
219       0    0    2    0    0         218 217 42
220       0    0    0    2    0         219 217 218
221       0    0    2    0    0         219 216 217
222       0    0    0    2    0         220 216 219
223       0    0    2    0    0         220 215 216
224       0    0    0    2    0         221 215 220
225       0    0    2    0    0         221 214 215
226       0    0    0    2    0         222 214 221
227       0    0    2    0    0         222 213 214
228       0    0    0    2    0         223 213 222
229       0    0    2    0    0         223 212 213
230       0    0    0    2    0         47 212 223
231       0    0    0    0    2         19 212 47
232       0    0    0    2    0         230 39 17
233       0    0    2    0    0         230 229 39
234       0    0    0    2    0         231 229 230
235       0    0    2    0    0         231 228 229
236       0    0    0    2    0         232 228 231
237       0    0    2    0    0         232 227 228
238       0    0    0    2    0         233 227 232
239       0    0    2    0    0         233 226 227
240       0    0    0    2    0         234 226 233
241       0    0    2    0    0         234 225 226
242       0    0    0    2    0         235 225 234
243       0    0    2    0    0         235 224 225
244       0    0    0    2    0         48 224 235
245       0    0    0    0    2         15 224 48
246       0    0    0    2    0         242 36 11
247       0    0    2    0    0         242 241 36
248       0    0    0    2    0         243 241 242
249       0    0    2    0    0         243 240 241
250       0    0    0    2    0         244 240 243
251       0    0    2    0    0         244 239 240
252       0    0    0    2    0         245 239 244
253       0    0    2    0    0         245 238 239
254       0    0    0    2    0         246 238 245
255       0    0    2    0    0         246 237 238
256       0    0    0    2    0         247 237 246
257       0    0    2    0    0         247 236 237
258       0    0    0    2    0         49 236 247
259       0    0    0    0    2         9 236 49
];

mcsf_end=1;

