/*
 * ***************************************************************************
 * MC = < Manifold Code >
 * Copyright (C) 1994--2008 Michael Holst 
 *
 * This library is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU Lesser General Public 
 * License as published by the Free Software Foundation; either  
 * version 2.1 of the License, or (at your option) any later version. 
 *
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details. 
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free Software  
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA   
 * 
 * rcsid="$Id: mainsmooth.c,v 1.1 2009/11/10 00:38:10 fetk Exp $"
 * ***************************************************************************
 */

/*
 * ***************************************************************************
 * File:     main.c
 *
 * Purpose:  Driver program for testing Bvec_smooth routine
 *
 * Notes:    A random non-symmetric block problem (with unequal block sizes)
 *           was generated in Matlab.  Exact solutions were generated for a
 *           random initial guess and random right hand side using all four
 *           permutations of key == 0,1 and adj = 0,1.  The exact solutions
 *           were generated using simple Matlab commands (backslash, tril, 
 *           triu, diag) to ensure correctness.  This routine will expose most
 *           bugs in Bvec_smooth, if any such bugs exist.  The Matlab code for 
 *           generating the test problem is attached at the end of this file
 *           as a comment.
 *
 * Author:   Stephen Bond
 * ***************************************************************************
 */

#include "mc/mc.h"

VPRIVATE Bmat* Bmat_example( )
{
   int numB,numR[MAXV];
   Mat *Ab;
   double *AD;
   int p, q, *IJA;
   MATmirror mirror[MAXV][MAXV];
   Bmat *thee = VNULL;

   numB = 3;
   VASSERT( numB <= MAXV );
   numR[0] = 50;
   numR[1] = 48;
   numR[2] = 52;
   mirror[0][0] = ISNOT_MIRROR;
   mirror[0][1] = ISNOT_MIRROR;
   mirror[0][2] = ISNOT_MIRROR;
   mirror[1][0] = ISNOT_MIRROR;
   mirror[1][1] = ISNOT_MIRROR;
   mirror[1][2] = ISNOT_MIRROR;
   mirror[2][0] = ISNOT_MIRROR;
   mirror[2][1] = IS_MIRROR;
   mirror[2][2] = ISNOT_MIRROR;
   thee = Bmat_ctor( VNULL, "A", numB, numR, numR, mirror );

   Ab = thee->AD[0][0];
   IJA = Vmem_malloc(Ab->vmem, 68, sizeof(int));

   IJA[0]=0;IJA[1]=0;IJA[2]=1;IJA[3]=1;IJA[4]=1;
   IJA[5]=2;IJA[6]=3;IJA[7]=4;IJA[8]=4;IJA[9]=5;
   IJA[10]=5;IJA[11]=5;IJA[12]=8;IJA[13]=8;IJA[14]=8;
   IJA[15]=9;IJA[16]=10;IJA[17]=11;IJA[18]=12;IJA[19]=12;
   IJA[20]=13;IJA[21]=14;IJA[22]=14;IJA[23]=15;IJA[24]=15;
   IJA[25]=15;IJA[26]=15;IJA[27]=15;IJA[28]=16;IJA[29]=16;
   IJA[30]=16;IJA[31]=16;IJA[32]=16;IJA[33]=16;IJA[34]=16;
   IJA[35]=16;IJA[36]=16;IJA[37]=16;IJA[38]=16;IJA[39]=17;
   IJA[40]=17;IJA[41]=17;IJA[42]=17;IJA[43]=17;IJA[44]=17;
   IJA[45]=17;IJA[46]=17;IJA[47]=17;IJA[48]=17;IJA[49]=17;
   IJA[50]=17;
   IJA[51]=35;IJA[52]=44;IJA[53]=12;IJA[54]=28;IJA[55]=39;
   IJA[56]=12;IJA[57]=20;IJA[58]=25;IJA[59]=22;IJA[60]=16;
   IJA[61]=37;IJA[62]=42;IJA[63]=21;IJA[64]=25;IJA[65]=34;
   IJA[66]=36;IJA[67]=45;
   Mat_initStructure(Ab, DRC_FORMAT, ISNOT_SYM, 17, IJA, VNULL);
   AD = Ab->A;

   AD[0]=2.3971913510e+00;AD[1]=1.6966581914e+00;AD[2]=1.5933705168e+00;
   AD[3]=1.8073668996e+00;AD[4]=1.9560576668e+00;AD[5]=1.6016693936e+00;
   AD[6]=2.4953897277e+00;AD[7]=1.8320928335e+00;AD[8]=1.7973468159e+00;
   AD[9]=1.5620452213e+00;AD[10]=1.7982439719e+00;AD[11]=1.5463512649e+00;
   AD[12]=2.0054281425e+00;AD[13]=2.2614258867e+00;AD[14]=2.1310699992e+00;
   AD[15]=1.5898916508e+00;AD[16]=1.5808624231e+00;AD[17]=2.2772405365e+00;
   AD[18]=2.4051347442e+00;AD[19]=2.0337719518e+00;AD[20]=1.6091542120e+00;
   AD[21]=2.3258088579e+00;AD[22]=1.8380977188e+00;AD[23]=1.7939730530e+00;
   AD[24]=2.2463134277e+00;AD[25]=1.5103366183e+00;AD[26]=1.5484473393e+00;
   AD[27]=2.1679161216e+00;AD[28]=2.1034679838e+00;AD[29]=2.0261024658e+00;
   AD[30]=2.2297094482e+00;AD[31]=2.2072534853e+00;AD[32]=2.2813770518e+00;
   AD[33]=1.7879769756e+00;AD[34]=2.1925319864e+00;AD[35]=2.0566698350e+00;
   AD[36]=1.8965207926e+00;AD[37]=1.5615906671e+00;AD[38]=2.2801755315e+00;
   AD[39]=1.8375838641e+00;AD[40]=2.1078659073e+00;AD[41]=2.2412540495e+00;
   AD[42]=1.6048132420e+00;AD[43]=1.6278883798e+00;AD[44]=2.0495401070e+00;
   AD[45]=1.9852294086e+00;AD[46]=2.3904756792e+00;AD[47]=2.2989602788e+00;
   AD[48]=2.2343410837e+00;AD[49]=1.5513318861e+00;
   AD[50]=-3.9030253548e-01;AD[51]=-1.5228732872e-01;AD[52]=2.3842683998e-01;
   AD[53]=-3.8078545895e-01;AD[54]=-4.0617997323e-01;AD[55]=-2.5715040168e-01;
   AD[56]=2.0928170271e-01;AD[57]=3.3291681908e-01;AD[58]=1.6194475191e-01;
   AD[59]=1.8336324329e-01;AD[60]=2.7198038555e-01;AD[61]=2.0052467390e-02;
   AD[62]=1.0730394069e-01;AD[63]=-2.4355900777e-01;AD[64]=2.2495305777e-02;
   AD[65]=2.6350464085e-01;AD[66]=8.6092067231e-02;
   AD[67]=4.1599124413e-01;AD[68]=-3.7550840758e-02;AD[69]=-1.7752819281e-01;
   AD[70]=-4.6423726673e-01;AD[71]=-2.6514007035e-02;AD[72]=-1.5887539295e-01;
   AD[73]=1.0738921377e-01;AD[74]=-3.0825474454e-01;AD[75]=2.6550001662e-01;
   AD[76]=7.6209380663e-02;AD[77]=4.6593114590e-02;AD[78]=1.4444278143e-01;
   AD[79]=1.3578671051e-01;AD[80]=-2.6376942301e-01;AD[81]=2.7028551480e-01;
   AD[82]=4.0739337124e-02;AD[83]=4.3285357028e-01;
   Ab = thee->AD[0][1];
   IJA = Vmem_malloc(Ab->vmem, 79, sizeof(int));

   IJA[0]=0;IJA[1]=1;IJA[2]=1;IJA[3]=1;IJA[4]=1;
   IJA[5]=3;IJA[6]=5;IJA[7]=5;IJA[8]=5;IJA[9]=5;
   IJA[10]=5;IJA[11]=5;IJA[12]=5;IJA[13]=5;IJA[14]=5;
   IJA[15]=6;IJA[16]=6;IJA[17]=6;IJA[18]=7;IJA[19]=7;
   IJA[20]=7;IJA[21]=8;IJA[22]=9;IJA[23]=9;IJA[24]=9;
   IJA[25]=11;IJA[26]=12;IJA[27]=12;IJA[28]=13;IJA[29]=14;
   IJA[30]=15;IJA[31]=15;IJA[32]=15;IJA[33]=15;IJA[34]=17;
   IJA[35]=18;IJA[36]=20;IJA[37]=20;IJA[38]=20;IJA[39]=22;
   IJA[40]=23;IJA[41]=23;IJA[42]=25;IJA[43]=25;IJA[44]=25;
   IJA[45]=25;IJA[46]=26;IJA[47]=27;IJA[48]=28;IJA[49]=28;
   IJA[50]=28;
   IJA[51]=24;IJA[52]=14;IJA[53]=26;IJA[54]=2;IJA[55]=17;
   IJA[56]=23;IJA[57]=2;IJA[58]=41;IJA[59]=36;IJA[60]=23;
   IJA[61]=29;IJA[62]=17;IJA[63]=25;IJA[64]=17;IJA[65]=15;
   IJA[66]=32;IJA[67]=38;IJA[68]=29;IJA[69]=20;IJA[70]=43;
   IJA[71]=15;IJA[72]=42;IJA[73]=21;IJA[74]=0;IJA[75]=46;
   IJA[76]=23;IJA[77]=28;IJA[78]=43;
   Mat_initStructure(Ab, ROW_FORMAT, ISNOT_SYM, 28, IJA, VNULL);
   AD = Ab->A;

   AD[0]=-4.4502585309e-01;AD[1]=-6.1355017413e-02;AD[2]=1.9666720056e-01;
   AD[3]=2.0404743033e-01;AD[4]=8.8026055308e-02;AD[5]=-3.8829425581e-01;
   AD[6]=-5.7694586617e-02;AD[7]=8.1446487875e-02;AD[8]=8.5987035826e-02;
   AD[9]=-3.6370745106e-01;AD[10]=-4.9947762464e-01;AD[11]=-3.4524765134e-01;
   AD[12]=6.0559527355e-02;AD[13]=-3.0013717714e-01;AD[14]=2.6885425243e-01;
   AD[15]=2.7680069338e-02;AD[16]=2.2975185532e-01;AD[17]=3.6543859101e-01;
   AD[18]=2.4870571822e-01;AD[19]=-4.8301706166e-01;AD[20]=-3.3274645451e-01;
   AD[21]=4.2831306231e-01;AD[22]=3.4064127371e-02;AD[23]=1.8779608512e-01;
   AD[24]=-2.9059491598e-01;AD[25]=1.7865230480e-01;AD[26]=4.8891161608e-01;
   AD[27]=-3.7914042890e-01;
   Ab = thee->AD[0][2];
   IJA = Vmem_malloc(Ab->vmem, 88, sizeof(int));

   IJA[0]=0;IJA[1]=0;IJA[2]=0;IJA[3]=1;IJA[4]=1;
   IJA[5]=2;IJA[6]=2;IJA[7]=3;IJA[8]=4;IJA[9]=5;
   IJA[10]=5;IJA[11]=5;IJA[12]=5;IJA[13]=7;IJA[14]=7;
   IJA[15]=9;IJA[16]=9;IJA[17]=10;IJA[18]=10;IJA[19]=11;
   IJA[20]=13;IJA[21]=13;IJA[22]=14;IJA[23]=14;IJA[24]=15;
   IJA[25]=16;IJA[26]=17;IJA[27]=17;IJA[28]=19;IJA[29]=19;
   IJA[30]=21;IJA[31]=21;IJA[32]=22;IJA[33]=22;IJA[34]=23;
   IJA[35]=25;IJA[36]=27;IJA[37]=28;IJA[38]=28;IJA[39]=30;
   IJA[40]=33;IJA[41]=33;IJA[42]=34;IJA[43]=34;IJA[44]=34;
   IJA[45]=35;IJA[46]=35;IJA[47]=36;IJA[48]=37;IJA[49]=37;
   IJA[50]=37;
   IJA[51]=42;IJA[52]=18;IJA[53]=3;IJA[54]=37;IJA[55]=45;
   IJA[56]=34;IJA[57]=35;IJA[58]=5;IJA[59]=22;IJA[60]=46;
   IJA[61]=8;IJA[62]=11;IJA[63]=37;IJA[64]=37;IJA[65]=19;
   IJA[66]=46;IJA[67]=15;IJA[68]=25;IJA[69]=29;IJA[70]=22;
   IJA[71]=45;IJA[72]=14;IJA[73]=39;IJA[74]=6;IJA[75]=38;
   IJA[76]=0;IJA[77]=48;IJA[78]=45;IJA[79]=6;IJA[80]=40;
   IJA[81]=3;IJA[82]=25;IJA[83]=26;IJA[84]=13;IJA[85]=15;
   IJA[86]=28;IJA[87]=15;
   Mat_initStructure(Ab, ROW_FORMAT, ISNOT_SYM, 37, IJA, VNULL);
   AD = Ab->A;

   AD[0]=-2.9105332601e-01;AD[1]=1.2095864394e-01;AD[2]=-3.7691625245e-01;
   AD[3]=4.8841792878e-01;AD[4]=2.4554607370e-01;AD[5]=1.6280806196e-01;
   AD[6]=3.9848613783e-01;AD[7]=-4.5734758909e-01;AD[8]=3.5893881668e-01;
   AD[9]=-3.6587706717e-01;AD[10]=3.5801055751e-02;AD[11]=3.7392740586e-01;
   AD[12]=3.9982099038e-02;AD[13]=2.0691741932e-01;AD[14]=4.3120138461e-01;
   AD[15]=-2.8739846664e-01;AD[16]=4.4793312129e-01;AD[17]=-2.0446616552e-01;
   AD[18]=5.9032544989e-02;AD[19]=2.8555898927e-01;AD[20]=2.3626745560e-01;
   AD[21]=-8.2971048357e-02;AD[22]=3.1820403891e-01;AD[23]=-2.1813314412e-01;
   AD[24]=-3.5160058375e-02;AD[25]=1.1471341912e-01;AD[26]=-2.5751344106e-01;
   AD[27]=6.1861425282e-02;AD[28]=3.8596678045e-02;AD[29]=-4.4329531093e-01;
   AD[30]=-2.9450582909e-01;AD[31]=-1.6706371816e-01;AD[32]=1.4819840647e-01;
   AD[33]=-2.9153864125e-01;AD[34]=-4.1792879290e-01;AD[35]=-4.7477181851e-01;
   AD[36]=-3.9429057342e-01;
   Ab = thee->AD[1][1];
   IJA = Vmem_malloc(Ab->vmem, 68, sizeof(int));

   IJA[0]=0;IJA[1]=3;IJA[2]=4;IJA[3]=5;IJA[4]=5;
   IJA[5]=5;IJA[6]=5;IJA[7]=5;IJA[8]=6;IJA[9]=6;
   IJA[10]=6;IJA[11]=8;IJA[12]=9;IJA[13]=9;IJA[14]=9;
   IJA[15]=9;IJA[16]=9;IJA[17]=10;IJA[18]=10;IJA[19]=10;
   IJA[20]=10;IJA[21]=12;IJA[22]=12;IJA[23]=12;IJA[24]=14;
   IJA[25]=14;IJA[26]=14;IJA[27]=16;IJA[28]=16;IJA[29]=16;
   IJA[30]=16;IJA[31]=16;IJA[32]=16;IJA[33]=16;IJA[34]=16;
   IJA[35]=16;IJA[36]=16;IJA[37]=16;IJA[38]=18;IJA[39]=18;
   IJA[40]=18;IJA[41]=19;IJA[42]=19;IJA[43]=19;IJA[44]=19;
   IJA[45]=19;IJA[46]=19;IJA[47]=19;IJA[48]=19;
   IJA[49]=9;IJA[50]=18;IJA[51]=30;IJA[52]=32;IJA[53]=39;
   IJA[54]=13;IJA[55]=22;IJA[56]=23;IJA[57]=20;IJA[58]=26;
   IJA[59]=25;IJA[60]=36;IJA[61]=35;IJA[62]=44;IJA[63]=35;
   IJA[64]=46;IJA[65]=40;IJA[66]=43;IJA[67]=43;
   Mat_initStructure(Ab, DRC_FORMAT, ISNOT_SYM, 19, IJA, VNULL);
   AD = Ab->A;

   AD[0]=1.5728852991e+00;AD[1]=1.5885274597e+00;AD[2]=2.2983508641e+00;
   AD[3]=2.4430081396e+00;AD[4]=2.1837155724e+00;AD[5]=1.6320829557e+00;
   AD[6]=2.2227245397e+00;AD[7]=1.6103534806e+00;AD[8]=1.6174928522e+00;
   AD[9]=2.1407179230e+00;AD[10]=1.8288142148e+00;AD[11]=2.1538120226e+00;
   AD[12]=2.2491314631e+00;AD[13]=2.0831857315e+00;AD[14]=2.2400323280e+00;
   AD[15]=1.7348269147e+00;AD[16]=2.2349575417e+00;AD[17]=2.4705985251e+00;
   AD[18]=2.3669302918e+00;AD[19]=1.5862345299e+00;AD[20]=1.8664366163e+00;
   AD[21]=1.8691988043e+00;AD[22]=2.1850284727e+00;AD[23]=2.0979416354e+00;
   AD[24]=2.2893639436e+00;AD[25]=1.8676529184e+00;AD[26]=1.7060278595e+00;
   AD[27]=1.5866665474e+00;AD[28]=2.2719339171e+00;AD[29]=1.7056745215e+00;
   AD[30]=1.8882716310e+00;AD[31]=2.0517785320e+00;AD[32]=1.7289532520e+00;
   AD[33]=2.1419406204e+00;AD[34]=1.9844803724e+00;AD[35]=1.6518455251e+00;
   AD[36]=2.2819319666e+00;AD[37]=1.6006063224e+00;AD[38]=1.7940663338e+00;
   AD[39]=1.7373730197e+00;AD[40]=2.0308722570e+00;AD[41]=1.5914987313e+00;
   AD[42]=1.9053154199e+00;AD[43]=1.6048462471e+00;AD[44]=1.6122839622e+00;
   AD[45]=2.2844278907e+00;AD[46]=1.7915703179e+00;AD[47]=2.1035334388e+00;
   
   AD[48]=3.0851409589e-01;AD[49]=-9.3045162861e-02;AD[50]=4.8995020571e-01;
   AD[51]=-2.0476614790e-02;AD[52]=3.9075211633e-01;AD[53]=-1.7243456592e-01;
   AD[54]=-4.1004932123e-01;AD[55]=-4.8229809103e-03;AD[56]=3.2558381579e-01;
   AD[57]=8.2790965176e-02;AD[58]=4.2960886676e-01;AD[59]=-2.5326547401e-01;
   AD[60]=3.4517818505e-01;AD[61]=3.4485567458e-01;AD[62]=2.3864029200e-01;
   AD[63]=5.2291341539e-02;AD[64]=4.8230322288e-01;AD[65]=3.6271071870e-01;
   AD[66]=-1.5703488788e-02;
   AD[67]=-1.4077178960e-01;AD[68]=2.3634007430e-01;AD[69]=-1.0529252472e-01;
   AD[70]=1.8341586697e-01;AD[71]=-4.8042237645e-01;AD[72]=3.8777095426e-01;
   AD[73]=-1.2260445516e-01;AD[74]=-2.8398108404e-01;AD[75]=2.9040721797e-01;
   AD[76]=1.4423456506e-02;AD[77]=2.8996302994e-01;AD[78]=-1.8147575460e-01;
   AD[79]=-3.1028959398e-01;AD[80]=-4.9941750098e-03;AD[81]=3.1539721148e-01;
   AD[82]=3.7901390460e-01;AD[83]=1.2595978517e-01;AD[84]=1.6094455795e-01;
   AD[85]=2.6902908534e-01;
   Ab = thee->AD[1][0];
   IJA = Vmem_malloc(Ab->vmem, 79, sizeof(int));

   IJA[0]=0;IJA[1]=1;IJA[2]=1;IJA[3]=1;IJA[4]=1;
   IJA[5]=3;IJA[6]=5;IJA[7]=5;IJA[8]=5;IJA[9]=5;
   IJA[10]=5;IJA[11]=5;IJA[12]=5;IJA[13]=5;IJA[14]=5;
   IJA[15]=6;IJA[16]=6;IJA[17]=6;IJA[18]=7;IJA[19]=7;
   IJA[20]=7;IJA[21]=8;IJA[22]=9;IJA[23]=9;IJA[24]=9;
   IJA[25]=11;IJA[26]=12;IJA[27]=12;IJA[28]=13;IJA[29]=14;
   IJA[30]=15;IJA[31]=15;IJA[32]=15;IJA[33]=15;IJA[34]=17;
   IJA[35]=18;IJA[36]=20;IJA[37]=20;IJA[38]=20;IJA[39]=22;
   IJA[40]=23;IJA[41]=23;IJA[42]=25;IJA[43]=25;IJA[44]=25;
   IJA[45]=25;IJA[46]=26;IJA[47]=27;IJA[48]=28;IJA[49]=28;
   IJA[50]=28;
   IJA[51]=24;IJA[52]=14;IJA[53]=26;IJA[54]=2;IJA[55]=17;
   IJA[56]=23;IJA[57]=2;IJA[58]=41;IJA[59]=36;IJA[60]=23;
   IJA[61]=29;IJA[62]=17;IJA[63]=25;IJA[64]=17;IJA[65]=15;
   IJA[66]=32;IJA[67]=38;IJA[68]=29;IJA[69]=20;IJA[70]=43;
   IJA[71]=15;IJA[72]=42;IJA[73]=21;IJA[74]=0;IJA[75]=46;
   IJA[76]=23;IJA[77]=28;IJA[78]=43;
   Mat_initStructure(Ab, COL_FORMAT, ISNOT_SYM, 28, IJA, VNULL);
   AD = Ab->A;

   AD[0]=-1.1322880548e-01;AD[1]=-7.5650960185e-02;AD[2]=-3.9083633971e-02;
   AD[3]=2.8473929476e-01;AD[4]=-2.8642846289e-02;AD[5]=-3.1133802321e-01;
   AD[6]=1.4761763017e-01;AD[7]=-3.8060375220e-01;AD[8]=-4.9862303034e-02;
   AD[9]=1.6200959836e-01;AD[10]=-8.3841410030e-02;AD[11]=1.1346073681e-01;
   AD[12]=3.6994103236e-01;AD[13]=4.3982947034e-01;AD[14]=1.4555187497e-01;
   AD[15]=1.4731148029e-01;AD[16]=4.3885934000e-02;AD[17]=4.9370462412e-01;
   AD[18]=-4.3640862902e-01;AD[19]=-9.5420004142e-02;AD[20]=4.7274085400e-01;
   AD[21]=-3.0797165057e-01;AD[22]=2.5404403859e-02;AD[23]=-1.0654363878e-01;
   AD[24]=1.7143113967e-01;AD[25]=-2.3785468227e-01;AD[26]=-4.5554590772e-01;
   AD[27]=-2.5721464218e-01;
   Ab = thee->AD[1][2];
   IJA = Vmem_malloc(Ab->vmem, 78, sizeof(int));

   IJA[0]=0;IJA[1]=0;IJA[2]=0;IJA[3]=2;IJA[4]=2;
   IJA[5]=2;IJA[6]=5;IJA[7]=6;IJA[8]=7;IJA[9]=9;
   IJA[10]=10;IJA[11]=10;IJA[12]=10;IJA[13]=11;IJA[14]=12;
   IJA[15]=13;IJA[16]=15;IJA[17]=16;IJA[18]=16;IJA[19]=16;
   IJA[20]=16;IJA[21]=16;IJA[22]=16;IJA[23]=16;IJA[24]=17;
   IJA[25]=18;IJA[26]=18;IJA[27]=18;IJA[28]=18;IJA[29]=18;
   IJA[30]=19;IJA[31]=19;IJA[32]=19;IJA[33]=24;IJA[34]=24;
   IJA[35]=24;IJA[36]=24;IJA[37]=26;IJA[38]=26;IJA[39]=26;
   IJA[40]=26;IJA[41]=26;IJA[42]=26;IJA[43]=27;IJA[44]=27;
   IJA[45]=27;IJA[46]=27;IJA[47]=27;IJA[48]=29;
   IJA[49]=34;IJA[50]=48;IJA[51]=5;IJA[52]=6;IJA[53]=45;
   IJA[54]=3;IJA[55]=18;IJA[56]=11;IJA[57]=47;IJA[58]=0;
   IJA[59]=24;IJA[60]=43;IJA[61]=24;IJA[62]=21;IJA[63]=41;
   IJA[64]=10;IJA[65]=16;IJA[66]=42;IJA[67]=22;IJA[68]=7;
   IJA[69]=8;IJA[70]=21;IJA[71]=22;IJA[72]=37;IJA[73]=20;
   IJA[74]=30;IJA[75]=32;IJA[76]=0;IJA[77]=13;
   Mat_initStructure(Ab, ROW_FORMAT, ISNOT_SYM, 29, IJA, VNULL);
   AD = Ab->A;

   AD[0]=-1.6917100480e-01;AD[1]=-4.4624560779e-01;AD[2]=1.3519791686e-01;
   AD[3]=1.9516303944e-01;AD[4]=-3.1580590248e-01;AD[5]=-3.5348508939e-01;
   AD[6]=7.3709764841e-02;AD[7]=-2.2970566771e-01;AD[8]=-4.2854718721e-01;
   AD[9]=-1.3758853773e-01;AD[10]=-3.6606874901e-01;AD[11]=-3.1531800096e-02;
   AD[12]=-4.6911045126e-01;AD[13]=-4.3659549931e-01;AD[14]=2.1885673661e-02;
   AD[15]=3.5299815534e-01;AD[16]=-3.3353955912e-01;AD[17]=4.0515355900e-01;
   AD[18]=1.3377418588e-02;AD[19]=-8.8398651741e-04;AD[20]=-5.4816834704e-02;
   AD[21]=3.6044056304e-01;AD[22]=-3.2239753949e-01;AD[23]=4.9949162010e-01;
   AD[24]=2.3784165380e-01;AD[25]=-1.5212080567e-01;AD[26]=-5.3973351945e-02;
   AD[27]=-4.5046742096e-01;AD[28]=6.4979570738e-02;
   Ab = thee->AD[2][2];
   IJA = Vmem_malloc(Ab->vmem, 71, sizeof(int));

   IJA[0]=0;IJA[1]=2;IJA[2]=2;IJA[3]=2;IJA[4]=3;
   IJA[5]=3;IJA[6]=3;IJA[7]=3;IJA[8]=3;IJA[9]=4;
   IJA[10]=5;IJA[11]=5;IJA[12]=5;IJA[13]=5;IJA[14]=6;
   IJA[15]=7;IJA[16]=8;IJA[17]=8;IJA[18]=8;IJA[19]=8;
   IJA[20]=9;IJA[21]=9;IJA[22]=10;IJA[23]=10;IJA[24]=10;
   IJA[25]=10;IJA[26]=11;IJA[27]=11;IJA[28]=11;IJA[29]=12;
   IJA[30]=12;IJA[31]=12;IJA[32]=12;IJA[33]=13;IJA[34]=14;
   IJA[35]=14;IJA[36]=14;IJA[37]=14;IJA[38]=15;IJA[39]=15;
   IJA[40]=17;IJA[41]=17;IJA[42]=18;IJA[43]=18;IJA[44]=18;
   IJA[45]=18;IJA[46]=18;IJA[47]=18;IJA[48]=18;IJA[49]=18;
   IJA[50]=18;IJA[51]=18;IJA[52]=18;
   IJA[53]=23;IJA[54]=46;IJA[55]=51;IJA[56]=24;IJA[57]=24;
   IJA[58]=38;IJA[59]=50;IJA[60]=21;IJA[61]=44;IJA[62]=39;
   IJA[63]=29;IJA[64]=35;IJA[65]=37;IJA[66]=45;IJA[67]=41;
   IJA[68]=43;IJA[69]=45;IJA[70]=42;
   Mat_initStructure(Ab, DRC_FORMAT, ISNOT_SYM, 18, IJA, VNULL);
   AD = Ab->A;

   AD[0]=2.4644226672e+00;AD[1]=1.9324849940e+00;AD[2]=2.1947521946e+00;
   AD[3]=2.2580992753e+00;AD[4]=1.9326423261e+00;AD[5]=2.1554980398e+00;
   AD[6]=1.6097550507e+00;AD[7]=2.4337598484e+00;AD[8]=1.6874608064e+00;
   AD[9]=1.7661788389e+00;AD[10]=2.2978302602e+00;AD[11]=1.9876037754e+00;
   AD[12]=2.2689582641e+00;AD[13]=1.8960067452e+00;AD[14]=1.7729387941e+00;
   AD[15]=1.5372346341e+00;AD[16]=2.1732949141e+00;AD[17]=1.9295644593e+00;
   AD[18]=1.5038171252e+00;AD[19]=2.1098571693e+00;AD[20]=1.5594032969e+00;
   AD[21]=1.8158114383e+00;AD[22]=2.2727221309e+00;AD[23]=2.1964329890e+00;
   AD[24]=1.6253321811e+00;AD[25]=1.6301514504e+00;AD[26]=1.5923523387e+00;
   AD[27]=1.5078202936e+00;AD[28]=1.9231093852e+00;AD[29]=2.1555731749e+00;
   AD[30]=2.2229225247e+00;AD[31]=2.0312092936e+00;AD[32]=1.6088179383e+00;
   AD[33]=2.1317663735e+00;AD[34]=1.6264998653e+00;AD[35]=1.6343033043e+00;
   AD[36]=1.5985940927e+00;AD[37]=1.6420272484e+00;AD[38]=1.6682512985e+00;
   AD[39]=1.6962489223e+00;AD[40]=1.8174797751e+00;AD[41]=1.8164289991e+00;
   AD[42]=1.7175633094e+00;AD[43]=1.7510418460e+00;AD[44]=2.3929224053e+00;
   AD[45]=2.2032232246e+00;AD[46]=2.0557379427e+00;AD[47]=1.6844336678e+00;
   AD[48]=1.7120308425e+00;AD[49]=1.5773468081e+00;AD[50]=2.4138004108e+00;
   AD[51]=2.2067152177e+00;
   AD[52]=-1.0141050326e-01;AD[53]=3.9494167544e-01;AD[54]=-4.8671679953e-01;
   AD[55]=4.3914170607e-01;AD[56]=-1.9869393541e-01;AD[57]=2.6395707849e-01;
   AD[58]=-5.8277942936e-02;AD[59]=4.3440511896e-01;AD[60]=-3.9598842522e-01;
   AD[61]=-3.9977845980e-01;AD[62]=3.5409994927e-01;AD[63]=-3.8184480155e-01;
   AD[64]=-2.1215065518e-01;AD[65]=9.7211350338e-02;AD[66]=-1.6415102532e-01;
   AD[67]=4.1213247424e-01;AD[68]=-2.0006300991e-01;AD[69]=1.7539117734e-01;
   
   AD[70]=-1.0430010823e-02;AD[71]=-3.0748960394e-01;AD[72]=-3.1092782553e-01;
   AD[73]=-3.7606772240e-01;AD[74]=-9.6427065320e-03;AD[75]=1.4031182516e-01;
   AD[76]=-2.9402448447e-01;AD[77]=-3.5795887810e-01;AD[78]=2.2866168168e-01;
   AD[79]=4.8439831224e-01;AD[80]=-3.2931812971e-02;AD[81]=3.4220661242e-01;
   AD[82]=-4.4576051556e-01;AD[83]=-3.2289246621e-01;AD[84]=-8.5477461107e-02;
   AD[85]=-3.2188304611e-01;AD[86]=-1.4036508652e-01;AD[87]=-3.2433097032e-01;
   
   Ab = thee->AD[2][0];
   IJA = Vmem_malloc(Ab->vmem, 88, sizeof(int));

   IJA[0]=0;IJA[1]=0;IJA[2]=0;IJA[3]=1;IJA[4]=1;
   IJA[5]=2;IJA[6]=2;IJA[7]=3;IJA[8]=4;IJA[9]=5;
   IJA[10]=5;IJA[11]=5;IJA[12]=5;IJA[13]=7;IJA[14]=7;
   IJA[15]=9;IJA[16]=9;IJA[17]=10;IJA[18]=10;IJA[19]=11;
   IJA[20]=13;IJA[21]=13;IJA[22]=14;IJA[23]=14;IJA[24]=15;
   IJA[25]=16;IJA[26]=17;IJA[27]=17;IJA[28]=19;IJA[29]=19;
   IJA[30]=21;IJA[31]=21;IJA[32]=22;IJA[33]=22;IJA[34]=23;
   IJA[35]=25;IJA[36]=27;IJA[37]=28;IJA[38]=28;IJA[39]=30;
   IJA[40]=33;IJA[41]=33;IJA[42]=34;IJA[43]=34;IJA[44]=34;
   IJA[45]=35;IJA[46]=35;IJA[47]=36;IJA[48]=37;IJA[49]=37;
   IJA[50]=37;
   IJA[51]=42;IJA[52]=18;IJA[53]=3;IJA[54]=37;IJA[55]=45;
   IJA[56]=34;IJA[57]=35;IJA[58]=5;IJA[59]=22;IJA[60]=46;
   IJA[61]=8;IJA[62]=11;IJA[63]=37;IJA[64]=37;IJA[65]=19;
   IJA[66]=46;IJA[67]=15;IJA[68]=25;IJA[69]=29;IJA[70]=22;
   IJA[71]=45;IJA[72]=14;IJA[73]=39;IJA[74]=6;IJA[75]=38;
   IJA[76]=0;IJA[77]=48;IJA[78]=45;IJA[79]=6;IJA[80]=40;
   IJA[81]=3;IJA[82]=25;IJA[83]=26;IJA[84]=13;IJA[85]=15;
   IJA[86]=28;IJA[87]=15;
   Mat_initStructure(Ab, COL_FORMAT, ISNOT_SYM, 37, IJA, VNULL);
   AD = Ab->A;

   AD[0]=-4.9884894287e-01;AD[1]=2.7015972861e-01;AD[2]=-3.2412558432e-01;
   AD[3]=2.2175803339e-01;AD[4]=-3.4727879956e-01;AD[5]=4.1742434205e-01;
   AD[6]=-2.3093841331e-01;AD[7]=-2.1250182693e-01;AD[8]=-4.0888653631e-01;
   AD[9]=-7.4271158129e-02;AD[10]=1.7901675409e-01;AD[11]=4.4517411311e-01;
   AD[12]=-2.9106507757e-01;AD[13]=-4.1274506351e-02;AD[14]=-1.4978198656e-01;
   AD[15]=3.4192915269e-01;AD[16]=8.2249164527e-02;AD[17]=-2.3522097352e-01;
   AD[18]=-1.8192592452e-01;AD[19]=-2.0536775051e-02;AD[20]=1.3931696104e-01;
   AD[21]=4.4716110527e-02;AD[22]=2.2104662058e-01;AD[23]=-2.8132336760e-01;
   AD[24]=-3.9420172675e-01;AD[25]=-5.1627087934e-02;AD[26]=-1.3418382316e-01;
   AD[27]=1.2789637961e-01;AD[28]=-3.6112579717e-01;AD[29]=1.9626633708e-01;
   AD[30]=3.0344218393e-02;AD[31]=3.6113981139e-01;AD[32]=-1.5146666448e-02;
   AD[33]=2.4125794345e-01;AD[34]=-3.5000274617e-01;AD[35]=2.5493326723e-01;
   AD[36]=-5.7597686998e-02;
   return thee;
}

VPRIVATE void Bvec_example( Bvec *thee, int key )
{
   int numB = 3, numR[MAXV];
   double *uu;

   VASSERT( numB <= MAXV );
   VASSERT( Bvec_numB(thee) == 3 );

   numR[0] = 50;
   VASSERT(Bvec_numRB(thee,0) == 50);
   numR[1] = 48;
   VASSERT(Bvec_numRB(thee,1) == 48);
   numR[2] = 52;
   VASSERT(Bvec_numRB(thee,2) == 52);
   switch(key) {
     case 0:

     uu = Vec_addr(thee->VC[0]);
     uu[0]=5.7788966755e-02;uu[1]=-1.8657101006e-01;uu[2]=-3.3379643710e-01;
     uu[3]=1.2249725928e-01;uu[4]=4.8793473495e-01;uu[5]=-3.2956797694e-01;
     uu[6]=-2.4220774943e-01;uu[7]=-1.0320068137e-01;uu[8]=-4.2600523042e-01;
     uu[9]=1.8409606696e-01;uu[10]=-9.7611667304e-02;uu[11]=4.8283520139e-01;
     uu[12]=-9.7816014778e-02;uu[13]=1.2067194720e-01;uu[14]=-3.4563019452e-01;
     uu[15]=-1.1865479556e-01;uu[16]=-3.3886602815e-01;uu[17]=2.5811243133e-01;
     uu[18]=3.7111112192e-01;uu[19]=-1.4922325511e-01;uu[20]=1.8553570875e-01;
     uu[21]=-2.0585136623e-01;uu[22]=3.0629303857e-02;uu[23]=3.3242338629e-01;
     uu[24]=9.7490191873e-02;uu[25]=-1.6468866929e-01;uu[26]=-2.0077497667e-01;
     uu[27]=-4.7407458431e-02;uu[28]=-7.7354346780e-02;uu[29]=-1.4039368203e-01;
     uu[30]=5.8319199869e-02;uu[31]=2.4254536570e-01;uu[32]=-7.5665216374e-02;
     uu[33]=-7.0644211424e-02;uu[34]=-3.7512724128e-01;uu[35]=-4.7556598395e-01;
     uu[36]=-2.0981473487e-01;uu[37]=-1.8247941710e-01;uu[38]=1.5369013397e-01;
     uu[39]=4.5693592407e-01;uu[40]=4.3573087278e-01;uu[41]=-4.2113666146e-02;
     uu[42]=-2.5952160317e-01;uu[43]=2.6389794429e-01;uu[44]=2.5932738313e-01;
     uu[45]=2.4064806498e-01;uu[46]=2.4368834149e-01;uu[47]=-3.9407958327e-01;
     uu[48]=1.8156043047e-01;uu[49]=-3.6739421406e-02;
     uu = Vec_addr(thee->VC[1]);
     uu[0]=-2.8783679475e-01;uu[1]=-4.0148126231e-01;uu[2]=3.2357447393e-01;
     uu[3]=-3.2499026262e-01;uu[4]=-3.3643009022e-01;uu[5]=1.6598721641e-01;
     uu[6]=3.9438937535e-01;uu[7]=1.6558208351e-02;uu[8]=2.0270230695e-01;
     uu[9]=-3.4640962338e-01;uu[10]=4.5345706989e-01;uu[11]=4.0884081241e-02;
     uu[12]=1.7973389821e-01;uu[13]=-4.6343698195e-01;uu[14]=3.0920385129e-01;
     uu[15]=2.4861887178e-01;uu[16]=-3.7981298201e-01;uu[17]=2.5045164763e-02;
     uu[18]=-1.7416637124e-01;uu[19]=4.6449439903e-02;uu[20]=-1.0111924762e-01;
     uu[21]=-8.4906613387e-02;uu[22]=-3.1926223975e-01;uu[23]=-2.4461325951e-01;
     uu[24]=-4.7946422534e-01;uu[25]=4.2367561262e-01;uu[26]=1.5369988901e-01;
     uu[27]=4.3261357205e-01;uu[28]=-3.3648763147e-01;uu[29]=4.2109725589e-01;
     uu[30]=2.9465788539e-01;uu[31]=7.7394196707e-02;uu[32]=-5.9964404240e-02;
     uu[33]=-2.4238626329e-01;uu[34]=2.5194639387e-01;uu[35]=-2.7133051789e-01;
     uu[36]=-4.3581291261e-01;uu[37]=2.6732951078e-01;uu[38]=1.7120218536e-01;
     uu[39]=2.1521251479e-01;uu[40]=1.4206082843e-01;uu[41]=-8.0951706375e-02;
     uu[42]=-1.0923791780e-01;uu[43]=3.1614010288e-01;uu[44]=-1.8257213634e-01;
     uu[45]=3.1453977290e-01;uu[46]=2.8907351494e-01;uu[47]=3.5226389034e-01;
     
     uu = Vec_addr(thee->VC[2]);
     uu[0]=5.6366175718e-03;uu[1]=1.3566138886e-01;uu[2]=4.5089441538e-01;
     uu[3]=-5.6035844981e-02;uu[4]=-4.3998118022e-01;uu[5]=3.6674989700e-01;
     uu[6]=1.3118873427e-01;uu[7]=-1.4492634812e-01;uu[8]=4.9700327161e-01;
     uu[9]=-2.7582850102e-01;uu[10]=1.5245107297e-01;uu[11]=1.0499064191e-01;
     uu[12]=-1.1275456852e-01;uu[13]=-3.5781284071e-01;uu[14]=-4.7486501429e-01;
     uu[15]=-7.8887746235e-02;uu[16]=-3.1589971057e-01;uu[17]=2.2577526747e-01;
     uu[18]=-1.2963731348e-01;uu[19]=3.4156008747e-01;uu[20]=2.3422969119e-01;
     uu[21]=7.1025872824e-02;uu[22]=-3.2314494237e-01;uu[23]=4.5738402260e-01;
     uu[24]=-2.3467796381e-01;uu[25]=4.2458089524e-01;uu[26]=-2.7622959530e-01;
     uu[27]=-1.2643619236e-01;uu[28]=-4.1249965042e-01;uu[29]=1.4011654825e-01;
     uu[30]=-3.1938311225e-01;uu[31]=-4.5494889253e-01;uu[32]=2.2317347918e-01;
     uu[33]=-1.5256235442e-01;uu[34]=1.6061682450e-01;uu[35]=-1.1613139893e-01;
     uu[36]=1.2734650244e-01;uu[37]=-4.7835018537e-01;uu[38]=4.1056998852e-01;
     uu[39]=3.0055865628e-01;uu[40]=2.4584748434e-01;uu[41]=3.1311281361e-01;
     uu[42]=-1.1669368137e-01;uu[43]=1.1727923232e-01;uu[44]=7.5494859703e-02;
     uu[45]=3.0051704765e-02;uu[46]=-2.2493024418e-01;uu[47]=-2.5137104034e-01;
     uu[48]=-4.8361229548e-02;uu[49]=-2.7228717397e-01;uu[50]=3.0444958361e-01;
     uu[51]=4.8610424190e-01;     break;
     case 1:

     uu = Vec_addr(thee->VC[0]);
     uu[0]=-4.7000804973e-01;uu[1]=3.5664190667e-02;uu[2]=-4.1292278010e-01;
     uu[3]=3.0209144056e-01;uu[4]=4.8914490970e-01;uu[5]=-4.3305374160e-01;
     uu[6]=4.3939836188e-01;uu[7]=-4.8182246636e-01;uu[8]=1.8383861375e-01;
     uu[9]=2.8373648008e-01;uu[10]=3.4137567883e-02;uu[11]=3.8535945093e-01;
     uu[12]=3.9900489891e-01;uu[13]=1.2593762608e-01;uu[14]=-3.6213100759e-01;
     uu[15]=-2.8219840629e-01;uu[16]=-3.1785892411e-01;uu[17]=-4.5818013603e-01;
     uu[18]=-3.9305834145e-01;uu[19]=1.1644348509e-01;uu[20]=4.3966101016e-01;
     uu[21]=-1.4554426903e-01;uu[22]=-8.9370909940e-02;uu[23]=4.8434941698e-01;
     uu[24]=4.4557918904e-01;uu[25]=1.7664467843e-01;uu[26]=4.8830226231e-01;
     uu[27]=2.6683138722e-01;uu[28]=-1.6330073561e-01;uu[29]=1.6238186040e-01;
     uu[30]=-2.5583471321e-01;uu[31]=-2.0449274917e-01;uu[32]=1.8017837123e-01;
     uu[33]=2.7846830419e-02;uu[34]=-8.8406486592e-02;uu[35]=1.0263821804e-01;
     uu[36]=2.5052005592e-01;uu[37]=8.3533174262e-02;uu[38]=5.1792514936e-02;
     uu[39]=8.3570618758e-02;uu[40]=1.1819919958e-02;uu[41]=-4.1740727300e-01;
     uu[42]=2.1957013486e-01;uu[43]=4.9615611130e-01;uu[44]=-1.4546569504e-01;
     uu[45]=4.7125881518e-01;uu[46]=-1.5355123870e-01;uu[47]=3.8654386176e-01;
     uu[48]=-4.5305135008e-02;uu[49]=-8.6572710979e-02;
     uu = Vec_addr(thee->VC[1]);
     uu[0]=-2.8226793164e-01;uu[1]=-3.7434541264e-01;uu[2]=-1.9108540643e-01;
     uu[3]=2.2610443166e-01;uu[4]=2.8287207298e-01;uu[5]=1.9378761499e-01;
     uu[6]=-4.9019774774e-01;uu[7]=3.4321333801e-01;uu[8]=4.2233199780e-01;
     uu[9]=2.7095422067e-01;uu[10]=-4.5734014406e-01;uu[11]=-1.2181386295e-01;
     uu[12]=2.0433962448e-01;uu[13]=2.2951304550e-01;uu[14]=-2.7572292934e-01;
     uu[15]=-2.3094526823e-01;uu[16]=1.7303116500e-01;uu[17]=-2.2507802273e-02;
     uu[18]=1.2371641267e-01;uu[19]=-2.6355506736e-01;uu[20]=-3.2287624550e-01;
     uu[21]=3.2964338570e-01;uu[22]=2.6692166794e-01;uu[23]=4.3447827312e-01;
     uu[24]=-3.9211109492e-01;uu[25]=-3.1777249440e-01;uu[26]=-4.0090471758e-01;
     uu[27]=-1.0236198077e-02;uu[28]=-3.0675466953e-01;uu[29]=3.9589157379e-01;
     uu[30]=-4.0091035032e-01;uu[31]=-4.5583442824e-01;uu[32]=5.7295155805e-02;
     uu[33]=2.7249506719e-01;uu[34]=-1.8805994250e-01;uu[35]=-3.2101752069e-01;
     uu[36]=-1.6104432175e-01;uu[37]=-2.8985436296e-01;uu[38]=1.0152519765e-02;
     uu[39]=4.0636432327e-01;uu[40]=1.2892393865e-01;uu[41]=-3.9846611119e-01;
     uu[42]=-1.0914524727e-01;uu[43]=-4.4538338478e-01;uu[44]=1.2829132032e-03;
     uu[45]=-6.8278828116e-02;uu[46]=4.9756034951e-01;uu[47]=3.1160258100e-01;
     
     uu = Vec_addr(thee->VC[2]);
     uu[0]=-1.4348330102e-02;uu[1]=3.9444775557e-01;uu[2]=-3.6245340523e-01;
     uu[3]=-1.0999508555e-01;uu[4]=4.2735622500e-01;uu[5]=4.1749383242e-01;
     uu[6]=2.1357401159e-01;uu[7]=1.1833738362e-01;uu[8]=-1.5671210976e-01;
     uu[9]=4.3602732669e-01;uu[10]=-3.7522595934e-01;uu[11]=2.3058536151e-01;
     uu[12]=1.4647743243e-01;uu[13]=3.3315198567e-01;uu[14]=-1.0171777178e-01;
     uu[15]=2.4982220936e-01;uu[16]=3.3522051048e-01;uu[17]=-1.7753960264e-01;
     uu[18]=5.2261616858e-02;uu[19]=4.7912913243e-01;uu[20]=4.9308533018e-02;
     uu[21]=-1.6957639039e-01;uu[22]=1.1947155518e-01;uu[23]=-1.3936342900e-01;
     uu[24]=2.5650954350e-01;uu[25]=-8.6099251310e-02;uu[26]=-7.6548956151e-03;
     uu[27]=1.9474323313e-01;uu[28]=4.7273388508e-01;uu[29]=-1.7224503951e-01;
     uu[30]=3.3780318308e-01;uu[31]=2.3907222727e-01;uu[32]=4.5417445638e-01;
     uu[33]=-4.6807737050e-01;uu[34]=-1.4313101382e-01;uu[35]=1.6265383429e-01;
     uu[36]=-2.1849844085e-01;uu[37]=-2.6961693268e-01;uu[38]=2.1112855118e-01;
     uu[39]=1.2457291699e-01;uu[40]=9.0608652920e-02;uu[41]=1.6043796631e-01;
     uu[42]=-4.5244532689e-01;uu[43]=-1.5121519149e-01;uu[44]=-4.8659419644e-02;
     uu[45]=-2.5909500288e-01;uu[46]=2.1504501330e-01;uu[47]=3.5618229201e-01;
     uu[48]=-2.1849230488e-01;uu[49]=2.3105082972e-01;uu[50]=-3.6223710748e-01;
     uu[51]=3.3672278175e-01;     break;
     case 2:

     uu = Vec_addr(thee->VC[0]);
     uu[0]=-2.8507612684e-01;uu[1]=-8.8379863085e-02;uu[2]=-2.8046638211e-01;
     uu[3]=1.6714450211e-01;uu[4]=2.7251825322e-01;uu[5]=-2.9841423404e-01;
     uu[6]=1.5581619434e-01;uu[7]=-1.3546674877e-01;uu[8]=2.0144011931e-01;
     uu[9]=1.8164421632e-01;uu[10]=1.8983835573e-02;uu[11]=2.4328522947e-01;
     uu[12]=2.0185566653e-01;uu[13]=5.5689477520e-02;uu[14]=-8.3691170072e-02;
     uu[15]=-1.3841372915e-01;uu[16]=-2.1505761058e-01;uu[17]=-1.9071660857e-01;
     uu[18]=-1.7082268853e-01;uu[19]=5.8216317662e-02;uu[20]=2.3615923265e-01;
     uu[21]=-7.3075759555e-03;uu[22]=-3.1941882250e-02;uu[23]=1.8788924046e-01;
     uu[24]=2.2360885510e-01;uu[25]=2.3697585266e-01;uu[26]=3.1534960856e-01;
     uu[27]=1.7297806689e-01;uu[28]=-3.9671659862e-02;uu[29]=8.9194068833e-02;
     uu[30]=-1.1473903625e-01;uu[31]=-1.1049605261e-01;uu[32]=7.8977901127e-02;
     uu[33]=-5.8986413264e-02;uu[34]=-8.6934180080e-02;uu[35]=1.4788625691e-01;
     uu[36]=1.2739855202e-01;uu[37]=5.9909027461e-02;uu[38]=1.1600391495e-01;
     uu[39]=1.0185648815e-01;uu[40]=5.6075293584e-03;uu[41]=-1.7118346111e-01;
     uu[42]=1.5398537712e-01;uu[43]=3.0478509304e-01;uu[44]=-8.2068101764e-02;
     uu[45]=2.3410232944e-01;uu[46]=-7.7340981873e-02;uu[47]=2.0674592147e-01;
     uu[48]=-2.0276731847e-02;uu[49]=-5.5805409374e-02;
     uu = Vec_addr(thee->VC[1]);
     uu[0]=-2.2519583524e-01;uu[1]=-2.3642857311e-01;uu[2]=-6.8077524121e-02;
     uu[3]=9.2551648929e-02;uu[4]=1.2953704986e-01;uu[5]=7.8483208270e-02;
     uu[6]=-2.2945064686e-01;uu[7]=1.6943877376e-01;uu[8]=2.0941334644e-01;
     uu[9]=1.1212525075e-01;uu[10]=-3.2230347352e-01;uu[11]=-4.1271509087e-02;
     uu[12]=5.2656484423e-02;uu[13]=8.0409362110e-02;uu[14]=-1.6303182001e-01;
     uu[15]=-1.5829275423e-01;uu[16]=4.7647999267e-02;uu[17]=-1.6390329956e-02;
     uu[18]=7.4754720794e-02;uu[19]=-1.6615138707e-01;uu[20]=-2.8864790892e-01;
     uu[21]=1.7497110611e-01;uu[22]=1.0407453679e-01;uu[23]=1.8475387994e-01;
     uu[24]=-1.6472307295e-01;uu[25]=-1.5959440528e-01;uu[26]=-2.0005922456e-01;
     uu[27]=-6.4513858273e-03;uu[28]=-1.5052684180e-01;uu[29]=2.7079135060e-01;
     uu[30]=-2.2487325520e-01;uu[31]=-2.2216551209e-01;uu[32]=1.4206022371e-01;
     uu[33]=1.2721877749e-01;uu[34]=-9.4765332588e-02;uu[35]=-1.2143520062e-01;
     uu[36]=-1.3939314999e-01;uu[37]=-2.9553685730e-01;uu[38]=7.1018520134e-03;
     uu[39]=2.1507088754e-01;uu[40]=8.4256505881e-02;uu[41]=-1.9389460704e-01;
     uu[42]=-3.2211941780e-02;uu[43]=-2.2008114597e-01;uu[44]=1.3680012114e-03;
     uu[45]=-2.9888808656e-02;uu[46]=3.3642651208e-01;uu[47]=1.6039308535e-01;
     
     uu = Vec_addr(thee->VC[2]);
     uu[0]=8.7721757214e-02;uu[1]=2.0411426572e-01;uu[2]=-1.6514548026e-01;
     uu[3]=4.1143404729e-02;uu[4]=2.2112535735e-01;uu[5]=1.8051444837e-01;
     uu[6]=1.3399080810e-01;uu[7]=4.8674877689e-02;uu[8]=-9.0596553531e-03;
     uu[9]=2.2047497678e-01;uu[10]=-1.7061556808e-01;uu[11]=1.2717443970e-01;
     uu[12]=6.4557129475e-02;uu[13]=1.3483930243e-01;uu[14]=-4.4578032181e-02;
     uu[15]=1.1882451941e-01;uu[16]=1.8259980988e-01;uu[17]=-9.2010195247e-02;
     uu[18]=-2.2510139082e-02;uu[19]=2.5459858352e-01;uu[20]=5.2880502757e-02;
     uu[21]=-7.0050992329e-02;uu[22]=5.6874747968e-02;uu[23]=-6.3033332141e-02;
     uu[24]=1.2183628681e-01;uu[25]=-8.0858056183e-02;uu[26]=-3.8384151641e-03;
     uu[27]=1.2915546631e-01;uu[28]=2.3301144842e-01;uu[29]=-6.6543158366e-02;
     uu[30]=1.4242448006e-01;uu[31]=1.1769945521e-01;uu[32]=2.1814374164e-01;
     uu[33]=-2.2094294344e-01;uu[34]=-1.4688425795e-01;uu[35]=7.9258239811e-02;
     uu[36]=-1.3668162659e-01;uu[37]=-8.8459681626e-02;uu[38]=9.4673625487e-02;
     uu[39]=7.6180977557e-02;uu[40]=3.7326957017e-02;uu[41]=9.7338262671e-02;
     uu[42]=-2.8764455433e-01;uu[43]=-7.0905429661e-02;uu[44]=-4.4663529276e-02;
     uu[45]=-1.1515918106e-01;uu[46]=7.2765878573e-02;uu[47]=2.6473336476e-01;
     uu[48]=-1.3377542739e-01;uu[49]=1.4648067789e-01;uu[50]=-1.5549924457e-01;
     uu[51]=1.5838718486e-01;     break;
     case 3:

     uu = Vec_addr(thee->VC[0]);
     uu[0]=-2.2115055831e-01;uu[1]=2.3484330612e-02;uu[2]=-2.9351800368e-01;
     uu[3]=1.6714450211e-01;uu[4]=2.7053981913e-01;uu[5]=-2.8029792915e-01;
     uu[6]=1.5676300813e-01;uu[7]=-2.3767370388e-01;uu[8]=1.2717804092e-01;
     uu[9]=1.8164421632e-01;uu[10]=1.8983835573e-02;uu[11]=2.0115223970e-01;
     uu[12]=1.7622107552e-01;uu[13]=5.5689477520e-02;uu[14]=-7.9775641717e-02;
     uu[15]=-1.5575897666e-01;uu[16]=-1.8847021435e-01;uu[17]=-2.0553553976e-01;
     uu[18]=-1.5987427882e-01;uu[19]=2.9570015114e-02;uu[20]=2.7924479713e-01;
     uu[21]=-4.2267589571e-02;uu[22]=2.4345769838e-03;uu[23]=2.1212061130e-01;
     uu[24]=3.3361671043e-01;uu[25]=1.8377540836e-01;uu[26]=3.1534960856e-01;
     uu[27]=9.8907547776e-02;uu[28]=-1.2989049440e-01;uu[29]=1.2254913629e-01;
     uu[30]=-1.1473903625e-01;uu[31]=-9.5289284784e-02;uu[32]=7.8977901127e-02;
     uu[33]=3.2328649569e-03;uu[34]=-9.2511654264e-02;uu[35]=1.0711411928e-02;
     uu[36]=1.3778083963e-01;uu[37]=6.3603093972e-02;uu[38]=9.0855261438e-04;
     uu[39]=2.3647134553e-02;uu[40]=5.6075293584e-03;uu[41]=-1.2247322658e-01;
     uu[42]=1.1358808152e-01;uu[43]=3.0478509304e-01;uu[44]=-1.6622026056e-02;
     uu[45]=1.7688845321e-01;uu[46]=2.5783799047e-03;uu[47]=1.3713756907e-01;
     uu[48]=-2.0276731847e-02;uu[49]=-5.5805409374e-02;
     uu = Vec_addr(thee->VC[1]);
     uu[0]=-1.2767794657e-01;uu[1]=-2.3433037971e-01;uu[2]=-1.3165889501e-01;
     uu[3]=9.2551648929e-02;uu[4]=1.2953704986e-01;uu[5]=6.8943447055e-02;
     uu[6]=-2.2001305162e-01;uu[7]=2.2699122339e-01;uu[8]=3.5533881980e-01;
     uu[9]=1.0856390776e-01;uu[10]=-2.1618888581e-01;uu[11]=-1.5935817867e-02;
     uu[12]=1.5610386129e-01;uu[13]=1.0649469844e-01;uu[14]=-2.2652293789e-02;
     uu[15]=-1.7057170395e-01;uu[16]=1.0105403750e-01;uu[17]=8.4031669842e-03;
     uu[18]=8.1009475772e-02;uu[19]=-1.6615138707e-01;uu[20]=-2.6872068756e-01;
     uu[21]=1.7014519815e-01;uu[22]=1.4760335115e-01;uu[23]=2.9985245745e-01;
     uu[24]=-1.3512059017e-01;uu[25]=-1.4505569219e-01;uu[26]=-1.9052646326e-01;
     uu[27]=-6.4513858273e-03;uu[28]=-8.6157190284e-02;uu[29]=3.4564618151e-01;
     uu[30]=-2.2836619798e-01;uu[31]=-2.2216551209e-01;uu[32]=1.0280848920e-01;
     uu[33]=1.2721877749e-01;uu[34]=-9.4765332588e-02;uu[35]=-2.6963476868e-01;
     uu[36]=-8.5195053098e-02;uu[37]=-9.9164029874e-02;uu[38]=7.3870217148e-03;
     uu[39]=3.2337139728e-01;uu[40]=4.3657216574e-02;uu[41]=-2.0600112197e-01;
     uu[42]=-2.4903951633e-02;uu[43]=-4.1958452893e-01;uu[44]=3.8003091849e-05;
     uu[45]=-2.9888808656e-02;uu[46]=2.4923696478e-01;uu[47]=1.4627078038e-01;
     
     uu = Vec_addr(thee->VC[2]);
     uu[0]=1.4316477165e-02;uu[1]=2.0411426572e-01;uu[2]=-1.6514548026e-01;
     uu[3]=3.3080287834e-03;uu[4]=2.2112535735e-01;uu[5]=1.4920248259e-01;
     uu[6]=8.1471311565e-02;uu[7]=4.8601498614e-02;uu[8]=-2.3851695333e-01;
     uu[9]=2.9197753877e-01;uu[10]=-1.0494799441e-01;uu[11]=1.7286018711e-01;
     uu[12]=6.4557129475e-02;uu[13]=1.5953029215e-01;uu[14]=-7.0324009406e-02;
     uu[15]=2.2270737989e-01;uu[16]=1.1670404697e-01;uu[17]=-9.2010195247e-02;
     uu[18]=-5.3716106171e-02;uu[19]=2.4074773416e-01;uu[20]=9.8090723040e-02;
     uu[21]=-2.5134508274e-02;uu[22]=-2.1868393562e-02;uu[23]=-6.3423122723e-02;
     uu[24]=4.0090415218e-01;uu[25]=-1.4406840772e-01;uu[26]=-4.6085251816e-04;
     uu[27]=1.2915546631e-01;uu[28]=2.4768012218e-01;uu[29]=-7.7421387739e-02;
     uu[30]=1.2213964665e-01;uu[31]=1.1769945521e-01;uu[32]=2.6611576749e-01;
     uu[33]=-2.1304666415e-01;uu[34]=-2.9241200900e-02;uu[35]=1.7207605607e-01;
     uu[36]=-1.3668162659e-01;uu[37]=-9.4964115860e-02;uu[38]=6.8010207914e-02;
     uu[39]=5.5070370309e-02;uu[40]=3.3257290731e-02;uu[41]=8.0987224621e-02;
     uu[42]=-1.8814474257e-01;uu[43]=-3.9452773845e-02;uu[44]=-5.2973353151e-02;
     uu[45]=-1.4310732053e-01;uu[46]=7.6992062192e-02;uu[47]=2.6302596770e-01;
     uu[48]=-8.0554552852e-02;uu[49]=1.4648067789e-01;uu[50]=-2.0791240496e-01;
     uu[51]=1.4469455585e-01;     break;
     case 4:

     uu = Vec_addr(thee->VC[0]);
     uu[0]=-2.2102969373e-01;uu[1]=2.3619248163e-02;uu[2]=-3.1169315556e-01;
     uu[3]=1.6714450211e-01;uu[4]=2.6863107036e-01;uu[5]=-2.8379492298e-01;
     uu[6]=1.6467328796e-01;uu[7]=-2.3409711014e-01;uu[8]=1.2648012834e-01;
     uu[9]=1.8164421632e-01;uu[10]=1.8983835573e-02;uu[11]=2.0818405515e-01;
     uu[12]=1.8799508153e-01;uu[13]=5.5689477520e-02;uu[14]=-9.9952928082e-02;
     uu[15]=-1.5582932398e-01;uu[16]=-1.8786025231e-01;uu[17]=-2.0527339042e-01;
     uu[18]=-1.6190877654e-01;uu[19]=3.8800710080e-02;uu[20]=2.9002582799e-01;
     uu[21]=-5.3018104792e-02;uu[22]=-3.5722984497e-02;uu[23]=2.1421201058e-01;
     uu[24]=3.0107645995e-01;uu[25]=1.5343077495e-01;uu[26]=3.1534960856e-01;
     uu[27]=1.0989917193e-01;uu[28]=-4.5583959223e-02;uu[29]=1.1237974600e-01;
     uu[30]=-1.1473903625e-01;uu[31]=-9.4889810804e-02;uu[32]=7.8977901127e-02;
     uu[33]=-5.9287259993e-03;uu[34]=-6.6172320445e-02;uu[35]=1.1297903039e-02;
     uu[36]=1.3213509506e-01;uu[37]=5.9909027461e-02;uu[38]=-3.2733524663e-03;
     uu[39]=3.7454228275e-02;uu[40]=5.6075293584e-03;uu[41]=-1.0773264344e-01;
     uu[42]=1.5398537712e-01;uu[43]=3.0478509304e-01;uu[44]=-3.1138721184e-02;
     uu[45]=1.9327150543e-01;uu[46]=2.0535449355e-02;uu[47]=1.6114912544e-01;
     uu[48]=-2.0276731847e-02;uu[49]=-5.5805409374e-02;
     uu = Vec_addr(thee->VC[1]);
     uu[0]=-1.3874083624e-01;uu[1]=-2.3403725819e-01;uu[2]=-1.0727112071e-01;
     uu[3]=9.2551648929e-02;uu[4]=1.2953704986e-01;uu[5]=6.5477330526e-02;
     uu[6]=-2.2522957344e-01;uu[7]=2.2246466112e-01;uu[8]=3.4930319813e-01;
     uu[9]=1.1295835261e-01;uu[10]=-2.2618805025e-01;uu[11]=-4.0317794167e-02;
     uu[12]=1.1068276162e-01;uu[13]=7.7560935754e-02;uu[14]=-8.8370147098e-02;
     uu[15]=-2.0213088850e-01;uu[16]=1.1260944208e-01;uu[17]=-1.6390329956e-02;
     uu[18]=7.4754720794e-02;uu[19]=-1.6615138707e-01;uu[20]=-1.0742829174e-01;
     uu[21]=1.7497110611e-01;uu[22]=1.0407453679e-01;uu[23]=2.0910914113e-01;
     uu[24]=-1.3446953691e-01;uu[25]=-1.5959440528e-01;uu[26]=-2.2247809293e-01;
     uu[27]=-6.4513858273e-03;uu[28]=-1.5052684180e-01;uu[29]=2.6781089776e-01;
     uu[30]=-2.2487325520e-01;uu[31]=-2.2216551209e-01;uu[32]=1.2554816502e-01;
     uu[33]=1.2721877749e-01;uu[34]=-9.4765332588e-02;uu[35]=-1.2143520062e-01;
     uu[36]=-8.9705895696e-02;uu[37]=-1.5535737544e-01;uu[38]=7.1018520134e-03;
     uu[39]=2.1507088754e-01;uu[40]=8.0110236051e-02;uu[41]=-1.9389460704e-01;
     uu[42]=-3.0972396194e-02;uu[43]=-2.2008114597e-01;uu[44]=1.3680012114e-03;
     uu[45]=-2.9888808656e-02;uu[46]=3.3642651208e-01;uu[47]=1.4659201611e-01;
     
     uu = Vec_addr(thee->VC[2]);
     uu[0]=1.8598715291e-02;uu[1]=2.0411426572e-01;uu[2]=-1.6514548026e-01;
     uu[3]=-2.9493612385e-02;uu[4]=2.2112535735e-01;uu[5]=1.8051444837e-01;
     uu[6]=1.3399080810e-01;uu[7]=4.8674877689e-02;uu[8]=-1.0183827021e-01;
     uu[9]=2.6058259099e-01;uu[10]=-1.7061556808e-01;uu[11]=1.2717443970e-01;
     uu[12]=6.4557129475e-02;uu[13]=1.7881756427e-01;uu[14]=-5.9696924977e-02;
     uu[15]=1.7087204514e-01;uu[16]=1.8259980988e-01;uu[17]=-9.2010195247e-02;
     uu[18]=-2.2510139082e-02;uu[19]=2.3204666298e-01;uu[20]=5.2880502757e-02;
     uu[21]=-1.1315533423e-01;uu[22]=5.6874747968e-02;uu[23]=-6.3033332141e-02;
     uu[24]=1.2183628681e-01;uu[25]=-3.5967631057e-02;uu[26]=-3.8384151641e-03;
     uu[27]=1.2915546631e-01;uu[28]=2.7180722280e-01;uu[29]=-6.6543158366e-02;
     uu[30]=1.4242448006e-01;uu[31]=1.1769945521e-01;uu[32]=2.6693072665e-01;
     uu[33]=-2.1432113607e-01;uu[34]=-1.4688425795e-01;uu[35]=7.9258239811e-02;
     uu[36]=-1.3668162659e-01;uu[37]=-1.0838019129e-01;uu[38]=9.4673625487e-02;
     uu[39]=1.0477682975e-01;uu[40]=3.7326957017e-02;uu[41]=1.1384497716e-01;
     uu[42]=-2.8764455433e-01;uu[43]=-7.0905429661e-02;uu[44]=-4.4663529276e-02;
     uu[45]=-1.1515918106e-01;uu[46]=7.2765878573e-02;uu[47]=2.6473336476e-01;
     uu[48]=-1.3377542739e-01;uu[49]=1.4648067789e-01;uu[50]=-1.5549924457e-01;
     uu[51]=1.5838718486e-01;     break;
     case 5:

     uu = Vec_addr(thee->VC[0]);
     uu[0]=-2.1871312485e-01;uu[1]=1.3762081083e-01;uu[2]=-2.9568471033e-01;
     uu[3]=1.6714450211e-01;uu[4]=2.8797942944e-01;uu[5]=-3.3829443629e-01;
     uu[6]=1.5441473374e-01;uu[7]=-2.0509030062e-01;uu[8]=1.1483044573e-01;
     uu[9]=1.8164421632e-01;uu[10]=1.8983835573e-02;uu[11]=1.9344136249e-01;
     uu[12]=2.1718171491e-01;uu[13]=5.5689477520e-02;uu[14]=-2.3491255106e-01;
     uu[15]=-1.6125226900e-01;uu[16]=-1.8755251949e-01;uu[17]=-2.0571362723e-01;
     uu[18]=-2.0041715129e-01;uu[19]=-2.0442205780e-02;uu[20]=2.0192403658e-01;
     uu[21]=-7.9466995945e-02;uu[22]=2.7236530395e-02;uu[23]=2.9850446444e-01;
     uu[24]=2.6595775687e-01;uu[25]=1.0929485501e-01;uu[26]=3.1534960856e-01;
     uu[27]=1.1255291134e-01;uu[28]=-5.4917618330e-02;uu[29]=5.6942752025e-02;
     uu[30]=-1.1473903625e-01;uu[31]=-8.3025639748e-02;uu[32]=7.8977901127e-02;
     uu[33]=-2.0845104831e-02;uu[34]=-4.4771519310e-02;uu[35]=6.6218919685e-02;
     uu[36]=1.1442971680e-01;uu[37]=8.6158161458e-02;uu[38]=-8.9652434627e-02;
     uu[39]=-1.2759804047e-02;uu[40]=5.6075293584e-03;uu[41]=-1.8351577083e-01;
     uu[42]=1.3939017626e-01;uu[43]=3.0478509304e-01;uu[44]=-6.3048780742e-02;
     uu[45]=2.1196279265e-01;uu[46]=-8.4366856504e-02;uu[47]=2.0153283106e-01;
     uu[48]=-2.0276731847e-02;uu[49]=-5.5805409374e-02;
     uu = Vec_addr(thee->VC[1]);
     uu[0]=-1.4265587279e-01;uu[1]=-2.2873195376e-01;uu[2]=-1.0852227994e-02;
     uu[3]=9.2551648929e-02;uu[4]=1.2953704986e-01;uu[5]=7.8483208270e-02;
     uu[6]=-2.2945064686e-01;uu[7]=3.3065800834e-01;uu[8]=2.0941334644e-01;
     uu[9]=1.4749309046e-01;uu[10]=-3.0946208262e-01;uu[11]=-4.2923013985e-02;
     uu[12]=5.2656484423e-02;uu[13]=1.3931928227e-01;uu[14]=-1.6434755308e-01;
     uu[15]=-1.4521864131e-01;uu[16]=5.2349689701e-02;uu[17]=1.1544528685e-02;
     uu[18]=4.6660847654e-02;uu[19]=-1.6615138707e-01;uu[20]=-2.8252230358e-01;
     uu[21]=1.7658797797e-01;uu[22]=6.4084726017e-02;uu[23]=1.0017716339e-01;
     uu[24]=-1.9313889816e-01;uu[25]=-1.0880745391e-01;uu[26]=-2.8479071856e-01;
     uu[27]=-6.4513858273e-03;uu[28]=-1.1686375707e-01;uu[29]=3.2211046224e-01;
     uu[30]=-1.7530109051e-01;uu[31]=-2.2216551209e-01;uu[32]=1.0957768570e-01;
     uu[33]=1.2721877749e-01;uu[34]=-9.4765332588e-02;uu[35]=-1.7412884408e-01;
     uu[36]=-1.4464003913e-01;uu[37]=-2.2405843241e-01;uu[38]=8.3284107133e-03;
     uu[39]=2.3633661261e-01;uu[40]=7.4813745413e-02;uu[41]=-2.6070527523e-01;
     uu[42]=-3.0808818900e-02;uu[43]=-1.5861085843e-01;uu[44]=-2.0631446342e-02;
     uu[45]=-2.9888808656e-02;uu[46]=2.5626886294e-01;uu[47]=1.6039308535e-01;
     
     uu = Vec_addr(thee->VC[2]);
     uu[0]=2.5188446931e-03;uu[1]=2.0411426572e-01;uu[2]=-1.6514548026e-01;
     uu[3]=6.4144447487e-03;uu[4]=2.2112535735e-01;uu[5]=1.3892212925e-01;
     uu[6]=1.1924244246e-01;uu[7]=4.8663079431e-02;uu[8]=-1.3735730556e-01;
     uu[9]=2.4559483241e-01;uu[10]=-1.7133785295e-01;uu[11]=1.4405924289e-01;
     uu[12]=6.4557129475e-02;uu[13]=1.1161350003e-01;uu[14]=-1.0767920667e-02;
     uu[15]=1.8175648276e-01;uu[16]=1.6961966597e-01;uu[17]=-9.2010195247e-02;
     uu[18]=-4.6180538370e-03;uu[19]=1.5790206907e-01;uu[20]=5.3680763212e-02;
     uu[21]=-2.7371811862e-01;uu[22]=9.6161708626e-02;uu[23]=-6.3333592414e-02;
     uu[24]=1.8938024543e-01;uu[25]=-3.7176544205e-02;uu[26]=-3.6197472433e-03;
     uu[27]=1.2915546631e-01;uu[28]=2.4565415543e-01;uu[29]=-7.6882155437e-02;
     uu[30]=1.4206542076e-01;uu[31]=1.1769945521e-01;uu[32]=1.4873154396e-01;
     uu[33]=-2.1502070167e-01;uu[34]=-1.1086741172e-01;uu[35]=1.0396582647e-01;
     uu[36]=-1.3668162659e-01;uu[37]=-9.0499276352e-02;uu[38]=1.0795328541e-01;
     uu[39]=3.7581578685e-02;uu[40]=2.7987188486e-02;uu[41]=6.1061153639e-02;
     uu[42]=-2.7420475178e-01;uu[43]=-9.2693840019e-02;uu[44]=5.7954123360e-03;
     uu[45]=-1.1556571877e-01;uu[46]=1.0792470076e-01;uu[47]=2.6473336476e-01;
     uu[48]=-1.2049012025e-01;uu[49]=1.4648067789e-01;uu[50]=-1.5032918137e-01;
     uu[51]=1.5400482901e-01;     break;
     case 6:

     uu = Vec_addr(thee->VC[0]);
     uu[0]=-2.0162887608e-01;uu[1]=3.0682420172e-02;uu[2]=-3.3393251114e-01;
     uu[3]=1.6714450211e-01;uu[4]=2.4140802812e-01;uu[5]=-2.2929271384e-01;
     uu[6]=1.6133204721e-01;uu[7]=-2.5610528542e-01;uu[8]=1.0322561145e-01;
     uu[9]=1.8164421632e-01;uu[10]=1.8983835573e-02;uu[11]=2.7719564894e-01;
     uu[12]=3.1244021736e-01;uu[13]=5.5689477520e-02;uu[14]=-1.1660755981e-01;
     uu[15]=-1.6848624962e-01;uu[16]=-1.8794962811e-01;uu[17]=-2.0712628614e-01;
     uu[18]=-1.5776426326e-01;uu[19]=1.6342467480e-02;uu[20]=1.5440102750e-01;
     uu[21]=-5.8334693776e-02;uu[22]=-6.6609632127e-03;uu[23]=2.8294742893e-01;
     uu[24]=1.9268117513e-01;uu[25]=3.3168456456e-02;uu[26]=3.1534960856e-01;
     uu[27]=1.3121988106e-01;uu[28]=-1.1525354461e-01;uu[29]=8.6988569843e-02;
     uu[30]=-1.1473903625e-01;uu[31]=-9.1170746295e-02;uu[32]=7.8977901127e-02;
     uu[33]=4.9963965499e-04;uu[34]=-7.8266911813e-02;uu[35]=-3.9408014183e-02;
     uu[36]=1.3809860455e-01;uu[37]=1.1251225494e-01;uu[38]=-1.5737303492e-02;
     uu[39]=-4.9314855841e-02;uu[40]=5.6075293584e-03;uu[41]=-2.3042586817e-01;
     uu[42]=1.3359457546e-01;uu[43]=3.0478509304e-01;uu[44]=-4.8778001222e-03;
     uu[45]=2.4686724371e-01;uu[46]=-1.3207718436e-01;uu[47]=1.0843159259e-01;
     uu[48]=-2.0276731847e-02;uu[49]=-5.5805409374e-02;
     uu = Vec_addr(thee->VC[1]);
     uu[0]=-1.7436457011e-01;uu[1]=-2.4367107547e-01;uu[2]=-3.9294311191e-02;
     uu[3]=9.2551648929e-02;uu[4]=1.2953704986e-01;uu[5]=1.0436163754e-01;
     uu[6]=-2.1234872699e-01;uu[7]=1.8711525214e-01;uu[8]=3.5457919203e-01;
     uu[9]=1.7243651966e-01;uu[10]=-2.1524948748e-01;uu[11]=-4.2861795896e-02;
     uu[12]=1.1030929235e-01;uu[13]=1.0904045849e-01;uu[14]=-8.4689595022e-02;
     uu[15]=-8.7477970186e-02;uu[16]=9.5941424254e-02;uu[17]=-2.9779231275e-02;
     uu[18]=4.0953716111e-02;uu[19]=-1.6615138707e-01;uu[20]=-1.0157327303e-01;
     uu[21]=1.6802828113e-01;uu[22]=2.0725653570e-01;uu[23]=1.3479153774e-01;
     uu[24]=-1.1776992659e-01;uu[25]=-1.4534809603e-01;uu[26]=-3.0141154143e-01;
     uu[27]=-6.4513858273e-03;uu[28]=-1.8745999925e-01;uu[29]=3.4012892422e-01;
     uu[30]=-1.3763096858e-01;uu[31]=-2.2216551209e-01;uu[32]=6.9420285631e-02;
     uu[33]=1.2721877749e-01;uu[34]=-9.4765332588e-02;uu[35]=-1.6542790592e-01;
     uu[36]=-7.6121404148e-02;uu[37]=-1.2946615860e-01;uu[38]=1.4705787579e-02;
     uu[39]=1.6112078961e-01;uu[40]=7.5871933192e-02;uu[41]=-2.5986658669e-01;
     uu[42]=-8.4387245002e-02;uu[43]=-5.7278621002e-01;uu[44]=5.3116687775e-02;
     uu[45]=-2.9888808656e-02;uu[46]=2.6640604283e-01;uu[47]=1.5828121625e-01;
     
     uu = Vec_addr(thee->VC[2]);
     uu[0]=6.8188958087e-02;uu[1]=2.0411426572e-01;uu[2]=-1.6514548026e-01;
     uu[3]=5.1501525350e-02;uu[4]=2.2112535735e-01;uu[5]=1.0994190947e-01;
     uu[6]=5.8033567706e-02;uu[7]=4.8601498614e-02;uu[8]=-7.6048918178e-02;
     uu[9]=2.4752874537e-01;uu[10]=-1.0494799441e-01;uu[11]=1.6751120070e-01;
     uu[12]=6.4557129475e-02;uu[13]=1.4419384220e-01;uu[14]=-7.2810484021e-02;
     uu[15]=1.7474768799e-01;uu[16]=1.1670404697e-01;uu[17]=-9.2010195247e-02;
     uu[18]=-5.3057040783e-03;uu[19]=1.5522992095e-01;uu[20]=9.8090723040e-02;
     uu[21]=-2.2242879476e-02;uu[22]=1.1380922991e-01;uu[23]=-6.3189643148e-02;
     uu[24]=1.1954168647e-01;uu[25]=-1.4931535612e-02;uu[26]=-4.7333790133e-02;
     uu[27]=1.2915546631e-01;uu[28]=3.0117459208e-01;uu[29]=-1.4835521882e-01;
     uu[30]=1.2213964665e-01;uu[31]=1.1769945521e-01;uu[32]=2.6287824538e-01;
     uu[33]=-2.1826358437e-01;uu[34]=-4.4553559878e-02;uu[35]=2.6997016381e-02;
     uu[36]=-1.3668162659e-01;uu[37]=-5.6880953244e-02;uu[38]=1.7526513411e-01;
     uu[39]=7.2752543855e-02;uu[40]=8.7340046813e-02;uu[41]=-5.4769039075e-04;
     uu[42]=-2.3886076022e-01;uu[43]=-1.6544331998e-01;uu[44]=3.6187726488e-02;
     uu[45]=8.6418887502e-03;uu[46]=5.6842897528e-02;uu[47]=2.6302596770e-01;
     uu[48]=-1.1481291411e-01;uu[49]=1.4648067789e-01;uu[50]=-1.6153417737e-01;
     uu[51]=1.4023068865e-01;     break;
     case 7:

     uu = Vec_addr(thee->VC[0]);
     uu[0]=-2.0387220063e-01;uu[1]=1.4526048010e-02;uu[2]=-3.4499793041e-01;
     uu[3]=1.6714450211e-01;uu[4]=2.4132425829e-01;uu[5]=-2.2983861815e-01;
     uu[6]=1.6128601332e-01;uu[7]=-2.5027073307e-01;uu[8]=8.1092944123e-02;
     uu[9]=1.8164421632e-01;uu[10]=1.8983835573e-02;uu[11]=2.8567134492e-01;
     uu[12]=2.9903607270e-01;uu[13]=5.5689477520e-02;uu[14]=-1.0750110257e-01;
     uu[15]=-1.6887535090e-01;uu[16]=-1.7983213814e-01;uu[17]=-2.0742067413e-01;
     uu[18]=-1.6023517214e-01;uu[19]=1.5058156093e-02;uu[20]=2.0270041520e-01;
     uu[21]=-6.5537609372e-02;uu[22]=-1.6501585699e-02;uu[23]=2.8380121753e-01;
     uu[24]=1.7997503617e-01;uu[25]=9.9421533110e-02;uu[26]=3.1534960856e-01;
     uu[27]=1.2835329055e-01;uu[28]=-5.2094671815e-02;uu[29]=1.0395851219e-01;
     uu[30]=-1.1473903625e-01;uu[31]=-9.0899724695e-02;uu[32]=7.8977901127e-02;
     uu[33]=7.4776137884e-03;uu[34]=-7.7682772322e-02;uu[35]=2.6487221734e-02;
     uu[36]=1.2424977327e-01;uu[37]=8.6158161458e-02;uu[38]=2.7948898225e-02;
     uu[39]=7.7206558998e-02;uu[40]=5.6075293584e-03;uu[41]=-2.2800836857e-01;
     uu[42]=1.3939017626e-01;uu[43]=3.0478509304e-01;uu[44]=-2.8906969309e-02;
     uu[45]=2.6428982536e-01;uu[46]=-1.0852609078e-01;uu[47]=1.5342518658e-01;
     uu[48]=-2.0276731847e-02;uu[49]=-5.5805409374e-02;
     uu = Vec_addr(thee->VC[1]);
     uu[0]=-1.6288513497e-01;uu[1]=-2.4919608346e-01;uu[2]=-4.0423854102e-02;
     uu[3]=9.2551648929e-02;uu[4]=1.2953704986e-01;uu[5]=7.0607672540e-02;
     uu[6]=-2.2679130313e-01;uu[7]=1.8055798849e-01;uu[8]=3.5170106653e-01;
     uu[9]=1.4982033510e-01;uu[10]=-2.1594435274e-01;uu[11]=-3.4085102721e-02;
     uu[12]=1.2167621969e-01;uu[13]=1.3614105921e-01;uu[14]=-7.5540737479e-02;
     uu[15]=-2.0730493088e-01;uu[16]=1.0638897782e-01;uu[17]=1.1544528685e-02;
     uu[18]=4.6660847654e-02;uu[19]=-1.6615138707e-01;uu[20]=-1.6666582620e-01;
     uu[21]=1.7658797797e-01;uu[22]=6.4084726017e-02;uu[23]=1.9212888578e-01;
     uu[24]=-1.6526383228e-01;uu[25]=-1.0880745391e-01;uu[26]=-2.9547267638e-01;
     uu[27]=-6.4513858273e-03;uu[28]=-1.1686375707e-01;uu[29]=3.1882188607e-01;
     uu[30]=-1.7530109051e-01;uu[31]=-2.2216551209e-01;uu[32]=1.1727125430e-01;
     uu[33]=1.2721877749e-01;uu[34]=-9.4765332588e-02;uu[35]=-1.7412884408e-01;
     uu[36]=-9.5060130570e-02;uu[37]=-1.7597828703e-01;uu[38]=8.3284107133e-03;
     uu[39]=2.3633661261e-01;uu[40]=1.3770387375e-01;uu[41]=-2.6070527523e-01;
     uu[42]=-2.9987876289e-02;uu[43]=-1.5861085843e-01;uu[44]=-2.0631446342e-02;
     uu[45]=-2.9888808656e-02;uu[46]=2.5626886294e-01;uu[47]=1.5295452958e-01;
     
     uu = Vec_addr(thee->VC[2]);
     uu[0]=4.1845842499e-02;uu[1]=2.0411426572e-01;uu[2]=-1.6514548026e-01;
     uu[3]=-3.9313814163e-02;uu[4]=2.2112535735e-01;uu[5]=1.3892212925e-01;
     uu[6]=1.1924244246e-01;uu[7]=4.8663079431e-02;uu[8]=-4.2851641012e-02;
     uu[9]=2.4791003899e-01;uu[10]=-1.7133785295e-01;uu[11]=1.4405924289e-01;
     uu[12]=6.4557129475e-02;uu[13]=1.3400830535e-01;uu[14]=-8.6188511815e-02;
     uu[15]=1.2103929041e-01;uu[16]=1.6961966597e-01;uu[17]=-9.2010195247e-02;
     uu[18]=-4.6180538370e-03;uu[19]=1.6545594195e-01;uu[20]=5.3680763212e-02;
     uu[21]=-1.8972075668e-01;uu[22]=9.6161708626e-02;uu[23]=-6.3333592414e-02;
     uu[24]=1.8938024543e-01;uu[25]=-4.1560284577e-02;uu[26]=-3.6197472433e-03;
     uu[27]=1.2915546631e-01;uu[28]=2.0648907908e-01;uu[29]=-7.6882155437e-02;
     uu[30]=1.4206542076e-01;uu[31]=1.1769945521e-01;uu[32]=2.5215360657e-01;
     uu[33]=-2.3707695023e-01;uu[34]=-1.1086741172e-01;uu[35]=1.0396582647e-01;
     uu[36]=-1.3668162659e-01;uu[37]=-1.0508412942e-01;uu[38]=1.0795328541e-01;
     uu[39]=-1.4313148099e-02;uu[40]=2.7987188486e-02;uu[41]=3.2936895368e-02;
     uu[42]=-2.7420475178e-01;uu[43]=-9.2693840019e-02;uu[44]=5.7954123360e-03;
     uu[45]=-1.1556571877e-01;uu[46]=1.0792470076e-01;uu[47]=2.6473336476e-01;
     uu[48]=-1.2049012025e-01;uu[49]=1.4648067789e-01;uu[50]=-1.5032918137e-01;
     uu[51]=1.5400482901e-01;     break;
     default:
     VASSERT(0);
   }
}

int main(int argc, char **argv)
{
    Bmat *A = VNULL;
    Bvec *u = VNULL;
    Bvec *ue = VNULL;
    Bvec *u0 = VNULL;
    Bvec *f = VNULL;
    Bvec *w = VNULL;
    int key, adj, ioflag=1, meth=1, itmax=1, p, numB, numR[MAXV];
    double r_err;
    char PF;

    /* Load a block matrix */
    A = Bmat_example();
    
    numB = A->numB;

    for( p=0; p<numB; p++ ) {
        numR[p] = Mat_numR( A->AD[p][p] );
    }

    /* Construct some block vectors */
    u  = Bvec_ctor( VNULL, "u",  numB, numR );
    u0 = Bvec_ctor( VNULL, "u0", numB, numR );
    f  = Bvec_ctor( VNULL, "f",  numB, numR );
    ue = Bvec_ctor( VNULL, "ue", numB, numR );
    w  = Bvec_ctor( VNULL, "w",  numB, numR );

    /* Load the initial guess and right hand side */
    Bvec_example( u0, 0 );
    Bvec_example( f, 1 );

    Vnm_print(1,"P = 1; F = 0; %% 1: Pass Test, 0: Fail Test\n");
    Vnm_print(1,"\n");
    Vnm_print(1,"smooth_test = [\n");
    Vnm_print(1,"%% -----------------------------------------------\n");
    Vnm_print(1,"%% Test  Pass/Fail  Relative Error  Key  Adj  Meth\n"),
    Vnm_print(1,"%% -----------------------------------------------\n");

    /* Run the forward smoother with A */
    key = 0; adj = 0; meth=1;
    Bvec_copy( u, u0 );
    Bvec_smooth( u, A, f, w, key, ioflag, meth, adj, itmax, 0, 0);
    Bvec_example( ue, 2 );
    Bvec_axpy( u, ue, -1.);  /* u = u - uexact */
    r_err = Bvec_nrm2(u)/Bvec_nrm2(ue);
    PF = (r_err < 1.0e-10) ? 'P' : 'F'; /* PASS OR FAIL */
    Vnm_print(1," %4d   %6c   %16.6e  %3d  %3d  %3d\n",
              1, PF, r_err, key, adj, meth);

    /* Run the adjoint smoother with A */
    key = 0; adj = 1; meth=1;
    Bvec_copy( u, u0 );
    Bvec_smooth( u, A, f, w, key, ioflag, meth, adj, itmax, 0, 0);
    Bvec_example( ue, 3 );
    Bvec_axpy( u, ue, -1.);  /* u = u - uexact */
    r_err = Bvec_nrm2(u)/Bvec_nrm2(ue);
    PF = (r_err < 1.0e-10) ? 'P' : 'F'; /* PASS OR FAIL */
    Vnm_print(1," %4d   %6c   %16.6e  %3d  %3d  %3d\n",
              2, PF, r_err, key, adj, meth);

    /* Run the self-adjoint smoother with A */
    key = 0; adj = 0; meth=2;
    Bvec_copy( u, u0 );
    Bvec_smooth( u, A, f, w, key, ioflag, meth, adj, itmax, 0, 0);
    Bvec_example( ue, 4 );
    Bvec_axpy( u, ue, -1.);  /* u = u - uexact */
    r_err = Bvec_nrm2(u)/Bvec_nrm2(ue);
    PF = (r_err < 1.0e-10) ? 'P' : 'F'; /* PASS OR FAIL */
    Vnm_print(1," %4d   %6c   %16.6e  %3d  %3d  %3d\n",
              3, PF, r_err, key, adj, meth);

    /* Run the forward smoother with A' */
    key = 1; adj = 0; meth=1;
    Bvec_copy( u, u0 );
    Bvec_smooth( u, A, f, w, key, ioflag, meth, adj, itmax, 0, 0);
    Bvec_example( ue, 5 );
    Bvec_axpy( u, ue, -1.);  /* u = u - uexact */
    r_err = Bvec_nrm2(u)/Bvec_nrm2(ue);
    PF = (r_err < 1.0e-10) ? 'P' : 'F'; /* PASS OR FAIL */
    Vnm_print(1," %4d   %6c   %16.6e  %3d  %3d  %3d\n",
              4, PF, r_err, key, adj, meth);


    /* Run the adjoint smoother with A' */
    key = 1; adj = 1; meth=1;
    Bvec_copy( u, u0 );
    Bvec_smooth( u, A, f, w, key, ioflag, meth, adj, itmax, 0, 0);
    Bvec_example( ue, 6 );
    Bvec_axpy( u, ue, -1.);  /* u = u - uexact */
    r_err = Bvec_nrm2(u)/Bvec_nrm2(ue);
    PF = (r_err < 1.0e-10) ? 'P' : 'F'; /* PASS OR FAIL */
    Vnm_print(1," %4d   %6c   %16.6e  %3d  %3d  %3d\n",
              5, PF, r_err, key, adj, meth);

    /* Run the self-adjoint smoother with A' */
    key = 1; adj = 0; meth=2;
    Bvec_copy( u, u0 );
    Bvec_smooth( u, A, f, w, key, ioflag, meth, adj, itmax, 0, 0);
    Bvec_example( ue, 7 );
    Bvec_axpy( u, ue, -1.);  /* u = u - uexact */
    r_err = Bvec_nrm2(u)/Bvec_nrm2(ue);
    PF = (r_err < 1.0e-10) ? 'P' : 'F'; /* PASS OR FAIL */
    Vnm_print(1," %4d   %6c   %16.6e  %3d  %3d  %3d\n",
              6, PF, r_err, key, adj, meth);

    Vnm_print(1,"%% -----------------------------------------------\n");
    Vnm_print(1,"];\n");

    /* Destroy the vectors and matrix */
    Bvec_dtor( &u0 );
    Bvec_dtor( &ue );
    Bvec_dtor( &u );
    Bvec_dtor( &f );
    Bvec_dtor( &w );
    Bmat_dtor( &A );

    Vnm_print(1,"\n");
    Vnm_print(1,"mc_leaks = [\n");
    Vnm_print(1,"%% --------------------------------------"
                "--------------------------------------\n");
    Vnm_print(1,"%%  Footprint        Areas       Malloc         Free"
                "    Highwater   Class\n"),
    Vnm_print(1,"%% --------------------------------------"
                "--------------------------------------\n");
    Vmem_print(VNULL);
    Vmem_printTotal();
    Vnm_print(1,"%% --------------------------------------"
                "--------------------------------------\n");
    Vnm_print(1,"];\n");

    /* normal return */
    return 0;
}

/* ************************************************************************* *
 *                   Matlab code for generating new problems                 *
 * ************************************************************************* *

% Size of each block
N  = cell(1,3);
N{1} = 50; N{2} = 48; N{3} = 52;
ismirror = [0 0 0; 0 0 0; 0 1 0];

% Number of blocks
Nb = length(N);

% Total number of rows
numRT = sum(cell2mat(N));
% Generate a global shifted random matrix
A = sprand(numRT,numRT,1/(numRT));
% Symmetrize the structure
A = 0.5*(A + A'); %'
% Randomize the values
randval = inline('rand(size(x)) - 0.5','x');
A = spfun(randval,A);
A = A + spdiags(1.5 + rand(numRT,1), 0, numRT, numRT);

% Enforce mirror symmetry
si = 0;
for ki = 1:1:Nb
  sj = 0;
  for kj = 1:1:Nb
    if( ki ~= kj && ismirror(ki,kj) )
      Asp = A( (sj+1):(sj+N{kj}), (si+1):(si+N{ki}) );
      A( (si+1):(si+N{ki}), (sj+1):(sj+N{kj}) ) = Asp'; %'
     end
    sj = sj + N{kj};
  end
  si = si + N{ki};
end


% Generate a random initial condition and rhs
u0 = rand(numRT,1) - 0.5;
f  = rand(numRT,1) - 0.5;

% Create Nb x Nb cell arrays
UIA = cell(Nb); UJA = cell(Nb); UA  = cell(Nb);
LIA = cell(Nb); LJA = cell(Nb); LA  = cell(Nb);
DA  = cell(Nb);

si = 0;
for ki = 1:1:Nb
  sj = 0;
  for kj = 1:1:(ki-1)
    % Convert lower off-diagonal to CSC
    Asp = A( (si+1):(si+N{ki}), (sj+1):(sj+N{kj}) );
    [LIA{ki,kj},LJA{ki,kj},LA{ki,kj}] = sp2csc(Asp);
    sj = sj + N{kj};
  end
  kj = ki;
  % Convert diagonal to DRC
  Asp = A( (si+1):(si+N{ki}), (sj+1):(sj+N{kj}) );
  [UIA{ki,kj},UJA{ki,kj},UA{ki,kj}] = sp2csr(triu(Asp,1 ));
  [LIA{ki,kj},LJA{ki,kj},LA{ki,kj}] = sp2csc(tril(Asp,-1));
  DA{ki,kj} = diag(Asp);
  sj = sj + N{kj};
  for kj = (ki+1):1:Nb
    % Convert upper off-diagonal to CSR
    Asp = A( (si+1):(si+N{ki}), (sj+1):(sj+N{kj}) );
    [UIA{ki,kj},UJA{ki,kj},UA{ki,kj}] = sp2csr(Asp);
    sj = sj + N{kj};
  end
  si = si + N{ki};
end

% Print the matrix as FETK C-Code
fid = fopen('problem.c','wt');
fprintf(fid,'VPRIVATE Bmat* Bmat_example( )\n{\n   int numB,numR[MAXV];\n');
fprintf(fid,'   Mat *Ab;\n   double *AD;\n   int p, q, *IJA;\n');
fprintf(fid,'   MATmirror mirror[MAXV][MAXV];\n   Bmat *thee = VNULL;\n\n');
fprintf(fid,'   numB = %d;\n',Nb);
fprintf(fid,'   VASSERT( numB <= MAXV );\n');
for ki = 1:1:Nb
  fprintf(fid,'   numR[%d] = %d;\n',ki-1,N{ki});
end
for ki = 1:1:Nb
  for kj = 1:1:Nb
    fprintf(fid,'   mirror[%d][%d] = ', ki-1, kj-1);
    if( ismirror(ki,kj) )
      fprintf(fid,'IS_MIRROR;\n');
    else
      fprintf(fid,'ISNOT_MIRROR;\n');
    end
  end
end
fprintf(fid,'   thee = Bmat_ctor( VNULL, "A", numB, numR, numR, mirror );\n');
fprintf(fid,'\n');
for ki = 1:1:Nb
   fprintf(fid,'   Ab = thee->AD[%d][%d];\n',ki-1,ki-1);
   numIJ = length([UIA{ki,ki}; UJA{ki,ki}]);
   fprintf(fid,'   IJA = Vmem_malloc(Ab->vmem, %d, sizeof(int));\n',numIJ);
   k = 0;
   fprintf(fid,'\n   ');
   for i=1:length(UIA{ki,ki})
     fprintf(fid,'IJA[%d]=%d;',k,UIA{ki,ki}(i)-1);
     k=k+1;
     if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
   end
   fprintf(fid,'\n   ');
   for i=1:length(UJA{ki,ki})
     fprintf(fid,'IJA[%d]=%d;',k,UJA{ki,ki}(i)-1);
     k=k+1;
     if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
   end
   fprintf(fid,'\n');
   fprintf(fid,'   Mat_initStructure(Ab, %s, %s, %d, IJA, VNULL);\n',...
               'DRC_FORMAT', 'ISNOT_SYM', length(UJA{ki,ki}));
   fprintf(fid,'   AD = Ab->A;\n');
   k=0;
   fprintf(fid,'\n   ');
   for i=1:length(DA{ki,ki})
     fprintf(fid,'AD[%d]=%16.10e;',k,DA{ki,ki}(i));
     k=k+1;
     if( 0 == mod(i,3) ) fprintf(fid,'\n   '); end;
   end
   fprintf(fid,'\n   ');
   for i=1:length(UA{ki,ki})
     fprintf(fid,'AD[%d]=%16.10e;',k,UA{ki,ki}(i));
     k=k+1;
     if( 0 == mod(i,3) ) fprintf(fid,'\n   '); end;
   end
   fprintf(fid,'\n   ');
   for i=1:length(LA{ki,ki})
     fprintf(fid,'AD[%d]=%16.10e;',k,LA{ki,ki}(i));
     k=k+1;
     if( 0 == mod(i,3) ) fprintf(fid,'\n   '); end;
   end
   fprintf(fid,'\n');
   for kj = 1:1:(ki-1)
    if( ismirror(ki,kj) ~= 1 )
      fprintf(fid,'   Ab = thee->AD[%d][%d];\n',ki-1,kj-1);
      numIJ = length([LIA{ki,kj}; LJA{ki,kj}]);
      fprintf(fid,'   IJA = Vmem_malloc(Ab->vmem, %d, sizeof(int));\n',numIJ);
      k = 0;
      fprintf(fid,'\n   ');
      for i=1:length(LIA{ki,kj})
        fprintf(fid,'IJA[%d]=%d;',k,LIA{ki,kj}(i)-1);
        k=k+1;
        if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n   ');
      for i=1:length(LJA{ki,kj})
        fprintf(fid,'IJA[%d]=%d;',k,LJA{ki,kj}(i)-1);
        k=k+1;
        if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n');
      fprintf(fid,'   Mat_initStructure(Ab, %s, %s, %d, IJA, VNULL);\n',...
               'COL_FORMAT', 'ISNOT_SYM', length(LJA{ki,kj}));
      fprintf(fid,'   AD = Ab->A;\n');
      k = 0;
      fprintf(fid,'\n   ');
      for i=1:length(LA{ki,kj})
        fprintf(fid,'AD[%d]=%16.10e;',k,LA{ki,kj}(i));
        k=k+1;
        if( 0 == mod(i,3) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n');
    end
   end
   for kj = (ki+1):1:Nb
    if( ismirror(ki,kj) ~= 1)
      fprintf(fid,'   Ab = thee->AD[%d][%d];\n',ki-1,kj-1);
      numIJ = length([UIA{ki,kj}; UJA{ki,kj}]);
      fprintf(fid,'   IJA = Vmem_malloc(Ab->vmem, %d, sizeof(int));\n',numIJ);
      k = 0;
      fprintf(fid,'\n   ');
      for i=1:length(UIA{ki,kj})
        fprintf(fid,'IJA[%d]=%d;',k,UIA{ki,kj}(i)-1);
        k=k+1;
        if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n   ');
      for i=1:length(UJA{ki,kj})
        fprintf(fid,'IJA[%d]=%d;',k,UJA{ki,kj}(i)-1);
        k=k+1;
        if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n');
      fprintf(fid,'   Mat_initStructure(Ab, %s, %s, %d, IJA, VNULL);\n',...
               'ROW_FORMAT', 'ISNOT_SYM', length(UJA{ki,kj}));
      fprintf(fid,'   AD = Ab->A;\n');
      k = 0;
      fprintf(fid,'\n   ');
      for i=1:length(UA{ki,kj})
        fprintf(fid,'AD[%d]=%16.10e;',k,UA{ki,kj}(i));
        k=k+1;
        if( 0 == mod(i,3) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n');
     end
   end
end
fprintf(fid,'   return thee;\n}\n\n');
fprintf(fid,'VPRIVATE void Bvec_example( Bvec *thee, int key )\n{\n');
fprintf(fid,'   int numB = %d, numR[MAXV];\n',Nb);
fprintf(fid,'   double *uu;\n\n');
fprintf(fid,'   VASSERT( numB <= MAXV );\n');
fprintf(fid,'   VASSERT( Bvec_numB(thee) == %d );\n\n',Nb);
for ki = 1:1:Nb
  fprintf(fid,'   numR[%d] = %d;\n',ki-1,N{ki});
  fprintf(fid,'   VASSERT(Bvec_numRB(thee,%d) == %d);\n',ki-1,N{ki});
end
fprintf(fid,'   switch(key) {\n');
fprintf(fid,'     case 0:\n');
si = 0;
for ki = 1:1:Nb
  fprintf(fid,'\n     uu = Vec_addr(thee->VC[%d]);\n     ', ki-1);
  for i=1:1:N{ki}
    fprintf(fid,'uu[%d]=%16.10e;',i-1,u0(si+i));
    if( 0 == mod(i,3) ) fprintf(fid,'\n     '); end;
  end
  si = si + N{ki};
end
fprintf(fid,'     break;\n     case 1:\n');
si = 0;
for ki = 1:1:Nb
  fprintf(fid,'\n     uu = Vec_addr(thee->VC[%d]);\n     ', ki-1);
  for i=1:1:N{ki}
    fprintf(fid,'uu[%d]=%16.10e;',i-1,f(si+i));
    if( 0 == mod(i,3) ) fprintf(fid,'\n     '); end;
  end
  si = si + N{ki};
end
fprintf(fid,'     break;\n     case 2:\n');
U = triu(A,1); L = tril(A,-1);
D = diag(diag(A));
uex = u0;
uex = (D + L) \ (f - U*u0);
si = 0;
for ki = 1:1:Nb
  fprintf(fid,'\n     uu = Vec_addr(thee->VC[%d]);\n     ', ki-1);
  for i=1:1:N{ki}
    fprintf(fid,'uu[%d]=%16.10e;',i-1,uex(si+i));
    if( 0 == mod(i,3) ) fprintf(fid,'\n     '); end;
  end
  si = si + N{ki};
end
fprintf(fid,'     break;\n     case 3:\n');
uex = u0;
uex = (D + U) \ (f - L*u0);
si = 0;
for ki = 1:1:Nb
  fprintf(fid,'\n     uu = Vec_addr(thee->VC[%d]);\n     ', ki-1);
  for i=1:1:N{ki}
    fprintf(fid,'uu[%d]=%16.10e;',i-1,uex(si+i));
    if( 0 == mod(i,3) ) fprintf(fid,'\n     '); end;
  end
  si = si + N{ki};
end
fprintf(fid,'     break;\n     case 4:\n');
uex = u0;
utmp = (D + L) \ (f - U*u0);
uex = (D + U) \ (f - L*utmp);
si = 0;
for ki = 1:1:Nb
  fprintf(fid,'\n     uu = Vec_addr(thee->VC[%d]);\n     ', ki-1);
  for i=1:1:N{ki}
    fprintf(fid,'uu[%d]=%16.10e;',i-1,uex(si+i));
    if( 0 == mod(i,3) ) fprintf(fid,'\n     '); end;
  end
  si = si + N{ki};
end
fprintf(fid,'     break;\n     case 5:\n');
A = A'; %'
U = triu(A,1); L = tril(A,-1);
D = diag(diag(A));
A = A'; %'
uex = u0;
uex = (D + L) \ (f - U*u0);
si = 0;
for ki = 1:1:Nb
  fprintf(fid,'\n     uu = Vec_addr(thee->VC[%d]);\n     ', ki-1);
  for i=1:1:N{ki}
    fprintf(fid,'uu[%d]=%16.10e;',i-1,uex(si+i));
    if( 0 == mod(i,3) ) fprintf(fid,'\n     '); end;
  end
  si = si + N{ki};
end
fprintf(fid,'     break;\n     case 6:\n');
uex = u0;
uex = (D + U) \ (f - L*u0);
si = 0;
for ki = 1:1:Nb
  fprintf(fid,'\n     uu = Vec_addr(thee->VC[%d]);\n     ', ki-1);
  for i=1:1:N{ki}
    fprintf(fid,'uu[%d]=%16.10e;',i-1,uex(si+i));
    if( 0 == mod(i,3) ) fprintf(fid,'\n     '); end;
  end
  si = si + N{ki};
end
fprintf(fid,'     break;\n     case 7:\n');
uex = u0;
utmp = (D + L) \ (f - U*u0);
uex = (D + U) \ (f - L*utmp);
si = 0;
for ki = 1:1:Nb
  fprintf(fid,'\n     uu = Vec_addr(thee->VC[%d]);\n     ', ki-1);
  for i=1:1:N{ki}
    fprintf(fid,'uu[%d]=%16.10e;',i-1,uex(si+i));
    if( 0 == mod(i,3) ) fprintf(fid,'\n     '); end;
  end
  si = si + N{ki};
end
fprintf(fid,'     break;\n     default:\n     VASSERT(0);\n   }\n');
fprintf(fid,'}\n\n');

 * ************************************************************************* *
 *                        Sparse Conversion Functions                        *
 * ************************************************************************* *

function [IA, JA, A] = sp2csc(B)
%
% [IA, JA, A] = sp2csc(B)
%
[m,n] = size(B);
nz = nnz(B);

% Allocate space
IA = zeros(n+1,1);
JA = zeros(nz,1);
A = zeros(nz,1);

IA(1) = 1;
for i = 1:n
  IA(i+1) = IA(i) + nnz(B(:,i));
  jset = find(B(:,i))';
  JA((IA(i)):(IA(i+1)-1)) = jset;
  A((IA(i)):(IA(i+1)-1)) = B(jset,i);
end

function [IA, JA, A] = sp2csr(B)
%
% [IA, JA, A] = sp2csr(B)
%
[m,n] = size(B);
nz = nnz(B);

% Allocate space
IA = zeros(m+1,1);
JA = zeros(nz,1);
A = zeros(nz,1);

IA(1) = 1;
for i = 1:m
  IA(i+1) = IA(i) + nnz(B(i,:));
  jset = find(B(i,:));
  JA((IA(i)):(IA(i+1)-1)) = jset;
  A((IA(i)):(IA(i+1)-1)) = B(i,jset);
end

 * ************************************************************************* *
 *                               End Matlab Code                             *
 * ************************************************************************* */
